/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecorationGenerator;
import com.gildedgames.aether.common.blocks.natural.BlockIceCrystal;
import com.gildedgames.orbis.lib.world.WorldSlice;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class WorldGenIceCrystals
implements WorldDecorationGenerator {
    private final IBlockState crystalState;
    private List<IBlockState> statesCanPlaceOn = Lists.newArrayList();
    private final int max;

    public WorldGenIceCrystals(int max) {
        this.crystalState = BlocksAether.highlands_ice_crystal.func_176223_P();
        this.max = max;
    }

    public void setStatesToPlaceOn(IBlockState ... states) {
        this.statesCanPlaceOn = Lists.newArrayList((Object[])states);
    }

    @Override
    public boolean generate(WorldSlice slice, Random rand, BlockPos pos) {
        int count = 0;
        for (int attempts = 0; attempts < 128; ++attempts) {
            int type;
            BlockPos randomPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            IBlockState above = slice.getBlockState(randomPos.func_177984_a());
            IBlockState below = slice.getBlockState(randomPos.func_177977_b());
            if (!slice.isAirBlock(randomPos)) continue;
            if (this.statesCanPlaceOn.isEmpty() || this.statesCanPlaceOn.contains(below)) {
                type = rand.nextInt(3);
                slice.setBlockState(randomPos, this.crystalState.func_177226_a((IProperty)BlockIceCrystal.PROPERTY_VARIANT, (Comparable)BlockIceCrystal.PROPERTY_VARIANT.fromMeta(type)));
                if (this.max > 0) {
                    if (count < this.max) {
                        ++count;
                    } else {
                        return true;
                    }
                }
            }
            if (!this.statesCanPlaceOn.isEmpty() && !this.statesCanPlaceOn.contains(above)) continue;
            type = rand.nextInt(3);
            slice.setBlockState(randomPos, this.crystalState.func_177226_a((IProperty)BlockIceCrystal.PROPERTY_VARIANT, (Comparable)BlockIceCrystal.PROPERTY_VARIANT.fromMeta(type += 3)));
            if (this.max <= 0) continue;
            if (count < this.max) {
                ++count;
                continue;
            }
            return true;
        }
        return true;
    }
}

