/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecorationGenerator;
import com.gildedgames.orbis.lib.util.ArrayHelper;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class WorldGenFloorPlacer
implements WorldDecorationGenerator {
    private final StateFetcher stateFetcher;
    private final Function<Random, List<IBlockState>> stateDefiner;
    private final int amount;
    private IBlockState[] statesCanPlaceOn = new IBlockState[]{BlocksAether.aether_grass.func_176223_P()};

    public WorldGenFloorPlacer(StateFetcher stateFetcher, Function<Random, List<IBlockState>> stateDefiner) {
        this(-1, stateFetcher, stateDefiner);
    }

    public WorldGenFloorPlacer(int amount, StateFetcher stateFetcher, Function<Random, List<IBlockState>> stateDefiner) {
        this.stateFetcher = stateFetcher;
        this.stateDefiner = stateDefiner;
        this.amount = amount;
    }

    public void setStatesToPlaceOn(IBlockState ... states) {
        this.statesCanPlaceOn = states;
    }

    @Override
    public boolean generate(WorldSlice slice, Random rand, BlockPos pos) {
        int count = 0;
        BlockPos.MutableBlockPos randomPos = new BlockPos.MutableBlockPos();
        List<IBlockState> states = this.stateDefiner.apply(rand);
        for (int attempts = 0; attempts < 128; ++attempts) {
            IBlockState below;
            randomPos.func_181079_c(pos.func_177958_n() + (rand.nextInt(16) - 8), pos.func_177956_o() + (rand.nextInt(8) - 4), pos.func_177952_p() + (rand.nextInt(16) - 8));
            if (!slice.isAirBlock((BlockPos)randomPos) || !ArrayHelper.contains((Object[])this.statesCanPlaceOn, (Object)(below = slice.getBlockState(randomPos.func_177977_b())))) continue;
            IBlockState chosen = this.stateFetcher.fetch(rand, states);
            slice.setBlockState((BlockPos)randomPos, chosen);
            if (this.amount <= 0) continue;
            if (count < this.amount) {
                ++count;
                continue;
            }
            return true;
        }
        return true;
    }

    public static interface StateFetcher {
        public IBlockState fetch(Random var1, List<IBlockState> var2);
    }
}

