/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.decorations;

import com.gildedgames.orbis.lib.util.ArrayHelper;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class WorldGenAetherMinable {
    private final IBlockState oreBlock;
    private final int numberOfBlocks;
    private final IBlockState[] predicate;
    private boolean emitsLight;
    private boolean isFloating;

    public WorldGenAetherMinable(IBlockState state, int blockCount, IBlockState[] replaceableStates) {
        this.oreBlock = state;
        this.numberOfBlocks = blockCount;
        this.predicate = replaceableStates;
    }

    public void setFloating(boolean val) {
        this.isFloating = val;
    }

    public void setEmitsLight(boolean val) {
        this.emitsLight = val;
    }

    public boolean generate(WorldSlice slice, Random rand, BlockPos position) {
        float f = rand.nextFloat() * (float)Math.PI;
        float fSin = MathHelper.func_76126_a((float)f);
        float d0 = (float)(position.func_177958_n() + 8) + fSin * (float)this.numberOfBlocks / 8.0f;
        float d1 = (float)(position.func_177958_n() + 8) - fSin * (float)this.numberOfBlocks / 8.0f;
        float d2 = (float)(position.func_177952_p() + 8) + fSin * (float)this.numberOfBlocks / 8.0f;
        float d3 = (float)(position.func_177952_p() + 8) - fSin * (float)this.numberOfBlocks / 8.0f;
        float d4 = (float)(position.func_177956_o() + rand.nextInt(3)) - 2.0f;
        float d5 = (float)(position.func_177956_o() + rand.nextInt(3)) - 2.0f;
        BlockPos.MutableBlockPos nextPos = new BlockPos.MutableBlockPos();
        for (int attempts = 0; attempts < this.numberOfBlocks; ++attempts) {
            float radius = (float)attempts / (float)this.numberOfBlocks;
            float radiusSin = MathHelper.func_76126_a((float)((float)Math.PI * radius));
            float d6 = d0 + (d1 - d0) * radius;
            float d7 = d4 + (d5 - d4) * radius;
            float d8 = d2 + (d3 - d2) * radius;
            float d9 = rand.nextFloat() * (float)this.numberOfBlocks / 16.0f;
            float d10 = (radiusSin + 1.0f) * d9 + 1.0f;
            float d11 = (radiusSin + 1.0f) * d9 + 1.0f;
            int minX = MathHelper.func_76141_d((float)(d6 - d10 / 2.0f));
            int minY = MathHelper.func_76141_d((float)(d7 - d11 / 2.0f));
            int minZ = MathHelper.func_76141_d((float)(d8 - d10 / 2.0f));
            int maxX = MathHelper.func_76141_d((float)(d6 + d10 / 2.0f));
            int maxY = MathHelper.func_76141_d((float)(d7 + d11 / 2.0f));
            int maxZ = MathHelper.func_76141_d((float)(d8 + d10 / 2.0f));
            float xStepFactor = ((float)minX + 0.5f - d6) / (d10 / 2.0f);
            float xStep = ((float)(minX + 1) + 0.5f - d6) / (d10 / 2.0f) - xStepFactor;
            float yStepFactor = ((float)minY + 0.5f - d7) / (d11 / 2.0f);
            float yStep = ((float)(minY + 1) + 0.5f - d7) / (d11 / 2.0f) - yStepFactor;
            float zStepFactor = ((float)minZ + 0.5f - d8) / (d10 / 2.0f);
            float zStep = ((float)(minZ + 1) + 0.5f - d8) / (d10 / 2.0f) - zStepFactor;
            float xDist = xStepFactor;
            for (int x = minX; x <= maxX; ++x) {
                float xDistSq = xDist * xDist;
                if (xDistSq < 1.0f) {
                    float yDist = yStepFactor;
                    for (int y = minY; y <= maxY; ++y) {
                        float yDistSq = yDist * yDist;
                        if (xDistSq + yDistSq < 1.0f) {
                            float zDist = zStepFactor;
                            for (int z = minZ; z <= maxZ; ++z) {
                                IBlockState state;
                                float zDistSq = zDist * zDist;
                                if (xDistSq + yDistSq + zDistSq < 1.0f && ArrayHelper.contains((Object[])this.predicate, (Object)(state = slice.getBlockState(x, y, z)))) {
                                    nextPos.func_181079_c(x, y, z);
                                    slice.setBlockState((BlockPos)nextPos, this.oreBlock);
                                    if (this.emitsLight) {
                                        slice.getWorld().func_175664_x((BlockPos)nextPos);
                                    }
                                    if (this.isFloating) {
                                        slice.getWorld().func_175684_a((BlockPos)nextPos, this.oreBlock.func_177230_c(), 0);
                                    }
                                }
                                zDist += zStep;
                            }
                        }
                        yDist += yStep;
                    }
                }
                xDist += xStep;
            }
        }
        return true;
    }
}

