/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes.magnetic_hills;

import com.gildedgames.aether.common.world.biomes.magnetic_hills.MagneticHillPillar;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class MagneticHillsData
implements NBT {
    private long seed;
    private int shaftCount;
    private int spawnRadius;
    private List<MagneticHillPillar> magneticPillars;
    private BlockPos center;

    private MagneticHillsData() {
    }

    public MagneticHillsData(BlockPos center, long seed, int shaftCount, int spawnRadius) {
        this.center = center;
        this.seed = seed;
        this.shaftCount = shaftCount;
        this.spawnRadius = spawnRadius;
    }

    public Collection<MagneticHillPillar> getMagneticPillars() {
        if (this.magneticPillars == null) {
            this.magneticPillars = Lists.newArrayList();
            Random rand = new Random(this.seed);
            for (int i = 0; i < this.shaftCount; ++i) {
                boolean negPillar = rand.nextInt(4) == 0;
                BlockPos pos = this.center.func_177982_a(rand.nextInt(this.spawnRadius) * (rand.nextBoolean() ? -1 : 1), (negPillar ? -rand.nextInt(30) : rand.nextInt(30)) + (negPillar ? -50 : 10), rand.nextInt(this.spawnRadius) * (rand.nextBoolean() ? -1 : 1));
                float elongationMod = rand.nextFloat() * 0.5f + 0.25f;
                int topHeight = rand.nextInt(10) + 30;
                double radius = rand.nextDouble() * 20.0 + 15.0;
                MagneticHillPillar pillar = new MagneticHillPillar(elongationMod, topHeight, pos, radius);
                this.magneticPillars.add(pillar);
            }
        }
        return this.magneticPillars;
    }

    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("center", this.center);
        tag.func_74772_a("seed", this.seed);
        tag.func_74768_a("shaftCount", this.shaftCount);
        tag.func_74768_a("spawnRadius", this.spawnRadius);
    }

    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.center = funnel.getPos("center");
        this.seed = tag.func_74763_f("seed");
        this.shaftCount = tag.func_74762_e("shaftCount");
        this.spawnRadius = tag.func_74762_e("spawnRadius");
    }
}

