/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes.irradiated_forests;

import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Rectangle;
import com.gildedgames.aether.common.math.delaunay.Site;
import com.gildedgames.aether.common.math.delaunay.Voronoi;
import com.gildedgames.aether.common.math.voronoi.VoronoiGraphUtils;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.CrackLineSegment;
import com.gildedgames.orbis.lib.util.ChunkMap;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class IrradiatedForestsData
implements NBT {
    private static final int NUM_LLOYD_RELAXATIONS = 1;
    private final ChunkMap<List<CrackLineSegment>> cracks = new ChunkMap();
    private Voronoi voronoi;
    private int crackPoints;
    private int islandWidth;
    private int islandLength;
    private long seed;
    private BlockPos min;
    private static final double ANGLE_COS = Math.cos(1.5707963267948966);
    private static final double ANGLE_SIN = Math.sin(1.5707963267948966);

    private IrradiatedForestsData() {
    }

    public IrradiatedForestsData(int crackPoints, long seed, IIslandBounds bounds) {
        this.crackPoints = crackPoints;
        this.seed = seed;
        this.islandWidth = bounds.getWidth();
        this.islandLength = bounds.getLength();
        this.min = new BlockPos(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
    }

    public boolean checkInit() {
        boolean generate;
        boolean bl = generate = this.voronoi == null;
        if (generate) {
            Random rand = new Random(this.seed);
            this.voronoi = new Voronoi(this.crackPoints, rand, new Rectangle(0.0, 0.0, this.islandWidth, this.islandLength));
            this.voronoi = VoronoiGraphUtils.lloydRelax(this.voronoi, 1);
            ArrayList sitesUsed = Lists.newArrayList();
            Site centerSite = null;
            double radiusX = (double)this.islandWidth / 2.0;
            double radiusZ = (double)this.islandLength / 2.0;
            double oldDist = Double.POSITIVE_INFINITY;
            for (Site s : this.voronoi.getSites()) {
                double newDistZ;
                double newDistX = Math.abs((radiusX - s.x) * (1.0 / radiusX));
                double newDist = Math.sqrt(newDistX * newDistX + (newDistZ = Math.abs((radiusZ - s.y) * (1.0 / radiusZ))) * newDistZ);
                if (!(newDist < oldDist)) continue;
                centerSite = s;
                oldDist = newDist;
            }
            if (centerSite == null) {
                throw new IllegalStateException("Couldn't find center site");
            }
            block1: for (int crackIt = 0; crackIt < 4; ++crackIt) {
                Site site = centerSite;
                for (int i = 0; i < 20; ++i) {
                    Site[] sites = this.voronoi.neighborSitesForSite(site);
                    Site end = null;
                    int sitesChecked = 0;
                    while (end == null || sitesUsed.contains(end)) {
                        end = sites[rand.nextInt(sites.length)];
                        if (++sitesChecked <= sites.length) continue;
                        continue block1;
                    }
                    Site a = site;
                    Site b = end;
                    Point[] divided = this.subdivideFractal(a, b, 4, 0.8, rand);
                    for (int j = 0; j < divided.length - 1; ++j) {
                        Point div1 = divided[j];
                        Point div2 = divided[j + 1];
                        this.addCrackLine(div1.x, div1.y, div2.x, div2.y);
                    }
                    sitesUsed.add(site);
                    site = end;
                }
            }
        }
        return generate;
    }

    private Point[] subdivideFractal(Point a, Point b, int subdivisionCount, double amplitude, Random rand) {
        Point[] values = new Point[]{a, b};
        for (int i = 0; i < subdivisionCount; ++i) {
            Point[] divided = new Point[(values.length - 1) * 3];
            for (int j = 0; j < values.length - 1; ++j) {
                Point div1 = values[j];
                Point div2 = values[j + 1];
                double centerX = Point.lerp(div1.x, div2.x, 0.5);
                double centerY = Point.lerp(div1.y, div2.y, 0.5);
                double cX = centerX + (div1.x - centerX) * ANGLE_COS - (div1.y - centerY) * ANGLE_SIN;
                double cY = centerY + (div1.x - centerX) * ANGLE_SIN - (div1.y - centerY) * ANGLE_COS;
                double dX = centerX + (div2.x - centerX) * ANGLE_COS - (div2.y - centerY) * ANGLE_SIN;
                double dY = centerY + (div2.x - centerX) * ANGLE_SIN - (div2.y - centerY) * ANGLE_COS;
                double zAlpha = 0.1 + (amplitude - 0.1) * rand.nextDouble();
                double zX = Point.lerp(cX, dX, zAlpha);
                double zY = Point.lerp(cY, dY, zAlpha);
                double lerpedX = Point.lerp(centerX, zX, 0.5);
                double lerpedY = Point.lerp(centerY, zY, 0.5);
                Point lerped = new Point(lerpedX, lerpedY);
                int n = j * 3;
                divided[n] = div1;
                divided[n + 1] = lerped;
                divided[n + 2] = div2;
            }
            values = divided;
        }
        return values;
    }

    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74772_a("seed", this.seed);
        tag.func_74768_a("crackPoints", this.crackPoints);
        tag.func_74768_a("width", this.islandWidth);
        tag.func_74768_a("length", this.islandLength);
        funnel.setPos("min", this.min);
    }

    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.seed = tag.func_74763_f("seed");
        this.crackPoints = tag.func_74762_e("crackPoints");
        this.islandWidth = tag.func_74762_e("width");
        this.islandLength = tag.func_74762_e("length");
        this.min = funnel.getPos("min");
    }

    public Collection<CrackLineSegment> getCracksInRegion(int chunkX, int chunkZ, int radius) {
        int minX = chunkX - radius;
        int minZ = chunkZ - radius;
        int maxX = chunkX + radius + 1;
        int maxZ = chunkZ + radius + 1;
        HashSet<CrackLineSegment> list = new HashSet<CrackLineSegment>();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                List lines = (List)this.cracks.get(x - (this.min.func_177958_n() >> 4), z - (this.min.func_177952_p() >> 4));
                if (lines == null) continue;
                list.addAll(lines);
            }
        }
        return list;
    }

    private void addCrackLine(double x0, double y0, double x1, double y1) {
        double t_next_vertical;
        int y_inc;
        double t_next_horizontal;
        int x_inc;
        CrackLineSegment segment = new CrackLineSegment((double)this.min.func_177958_n() + x0, (double)this.min.func_177958_n() + x1, (double)this.min.func_177952_p() + y0, (double)this.min.func_177952_p() + y1);
        double dx = Math.abs((x1 /= 16.0) - (x0 /= 16.0));
        double dy = Math.abs((y1 /= 16.0) - (y0 /= 16.0));
        int x = (int)(Math.floor(x0) / 1.0);
        int y = (int)(Math.floor(y0) / 1.0);
        double dt_dx = 1.0 / dx;
        double dt_dy = 1.0 / dy;
        double t = 0.0;
        int n = 1;
        if (dx == 0.0) {
            x_inc = 0;
            t_next_horizontal = dt_dx;
        } else if (x1 > x0) {
            x_inc = 1;
            n += (int)Math.floor(x1) - x;
            t_next_horizontal = (Math.floor(x0) + 1.0 - x0) * dt_dx;
        } else {
            x_inc = -1;
            n += x - (int)Math.floor(x1);
            t_next_horizontal = (x0 - Math.floor(x0)) * dt_dx;
        }
        if (dy == 0.0) {
            y_inc = 0;
            t_next_vertical = dt_dy;
        } else if (y1 > y0) {
            y_inc = 1;
            n += (int)Math.floor(y1) - y;
            t_next_vertical = (Math.floor(y0) + 1.0 - y0) * dt_dy;
        } else {
            y_inc = -1;
            n += y - (int)Math.floor(y1);
            t_next_vertical = (y0 - Math.floor(y0)) * dt_dy;
        }
        while (n > 0) {
            ArrayList<CrackLineSegment> list = (ArrayList<CrackLineSegment>)this.cracks.get(x, y);
            if (list == null) {
                list = new ArrayList<CrackLineSegment>();
                this.cracks.put(x, y, list);
            }
            list.add(segment);
            if (t_next_vertical < t_next_horizontal) {
                y += y_inc;
                t = t_next_vertical;
                t_next_vertical += dt_dy;
            } else {
                x += x_inc;
                t = t_next_horizontal;
                t_next_horizontal += dt_dx;
            }
            --n;
        }
    }
}

