/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes.highlands;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.decoration.WorldDecorationSimple;
import com.gildedgames.aether.api.world.generation.BlueprintWorldGen;
import com.gildedgames.aether.api.world.generation.positioners.PositionerLevels;
import com.gildedgames.aether.api.world.generation.positioners.PositionerSurface;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.common.init.GenerationAether;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.island.IslandVariables;
import com.gildedgames.aether.common.world.island.generators.IslandGeneratorHighlandMegacoast;
import com.gildedgames.aether.common.world.island.generators.IslandGeneratorHighlands;
import com.gildedgames.aether.common.world.templates.TemplateWorldGen;
import com.gildedgames.aether.common.world.util.GenUtil;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeHighlands
extends BiomeAetherBase {
    public BiomeHighlands(Biome.BiomeProperties properties, ResourceLocation registryName) {
        super(properties, registryName);
    }

    @Override
    public IBlockState getCoastalBlock() {
        return BlocksAether.quicksoil.func_176223_P();
    }

    @Override
    public IIslandGenerator createIslandGenerator(Random rand, IIslandData islandData) {
        boolean firstIsland;
        int range = rand.nextInt(20);
        boolean bl = firstIsland = islandData.getBounds().getMinX() == 0 && islandData.getBounds().getMinZ() == 0;
        if (range < 3) {
            return new IslandGeneratorHighlandMegacoast();
        }
        int coastHeight = 1 + rand.nextInt(3);
        double coastSpread = rand.nextDouble() * 0.6;
        if (coastHeight == 0) {
            coastSpread = 0.0;
        }
        return new IslandGeneratorHighlands(IslandVariables.build().coastHeight(coastHeight).coastSpread(coastSpread).lakeBlendRange(0.05 + rand.nextDouble() * 0.5).lakeDepth(rand.nextInt(40) + 5).lakeScale(40.0 + rand.nextDouble() * 30.0).lakeThreshold(rand.nextDouble() * 0.3).maxTerrainHeight(firstIsland ? 10 + rand.nextInt(30) : 10 + rand.nextInt(120)).terraces(rand.nextBoolean()).lakeConcentrationModifier(0.5 + rand.nextDouble() * -2.5));
    }

    @Override
    public Collection<NBT> createIslandComponents(IIslandData islandData) {
        return Collections.emptyList();
    }

    @Override
    public float getRarityWeight() {
        return 1.0f;
    }

    @Override
    public void postDecorate(World world, Random rand, BlockPos pos) {
    }

    @Override
    public List<WorldDecoration> createBasicDecorations(Random rand) {
        ArrayList decorations = Lists.newArrayList();
        decorations.add(new WorldDecorationSimple(2, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.short_aether_grass));
        decorations.add(new WorldDecorationSimple(1, 0.2f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.skyroot_twigs));
        ArrayList flowers = Lists.newArrayList();
        flowers.addAll(GenUtil.GENERAL_FLOWER_STATES);
        decorations.add(GenUtil.createFlowerDecorations(rand, flowers, Lists.newArrayList((Object[])new IBlockState[]{BlocksAether.highlands_tulips.func_176223_P()})));
        decorations.add(GenUtil.createShroomDecorations(GenUtil.SHROOM_STATES));
        decorations.add(new WorldDecorationSimple(6, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerLevels(0, 128), GenerationAether.holystone_rocks));
        return decorations;
    }

    @Override
    public List<WorldDecoration> createTreeDecorations(Random rand) {
        ArrayList treeDecorations = Lists.newArrayList();
        BlueprintDefinition[] forest = new BlueprintDefinition[]{GenerationAether.SKYROOT_OAK_GREEN, GenerationAether.WISPROOT_GREEN};
        BlueprintDefinition[] neopolitan = new BlueprintDefinition[]{GenerationAether.SKYROOT_OAK_GREEN, GenerationAether.SKYROOT_OAK_DARK_BLUE, GenerationAether.SKYROOT_OAK_BLUE, GenerationAether.WISPROOT_GREEN, GenerationAether.WISPROOT_BLUE, GenerationAether.WISPROOT_DARK_BLUE};
        BlueprintDefinition[] chosen = rand.nextBoolean() ? neopolitan : forest;
        int amountOfTreeTypes = 2 + rand.nextInt(4);
        for (int i = 0; i < amountOfTreeTypes; ++i) {
            treeDecorations.add(new WorldDecorationSimple(15, 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(chosen[rand.nextInt(chosen.length)])));
        }
        treeDecorations.add(new WorldDecorationSimple(1 + rand.nextInt(3), 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new TemplateWorldGen(GenerationAether.skyroot_moa_nest_tree_1)));
        float k = rand.nextFloat();
        treeDecorations.add(new WorldDecorationSimple(1 + rand.nextInt(3), 0.5f * k, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(GenerationAether.AMBEROOT_TREE)));
        return treeDecorations;
    }

    @Override
    public float createForestTreeCountModifier(Random rand) {
        return 0.75f + rand.nextFloat() * 0.25f;
    }

    @Override
    public float createOpenAreaDecorationGenChance(Random rand) {
        return 0.8f * rand.nextFloat();
    }
}

