/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes.forgotten_highlands;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.decoration.WorldDecorationSimple;
import com.gildedgames.aether.api.world.generation.BlueprintWorldGen;
import com.gildedgames.aether.api.world.generation.positioners.PositionerLevels;
import com.gildedgames.aether.api.world.generation.positioners.PositionerSurface;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.init.GenerationAether;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.island.generators.IslandGeneratorForgottenHighlands;
import com.gildedgames.aether.common.world.util.GenUtil;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeForgottenHighlands
extends BiomeAetherBase {
    public BiomeForgottenHighlands(Biome.BiomeProperties properties, ResourceLocation registryName) {
        super(properties, registryName);
        this.field_76752_A = BlocksAether.aether_grass.func_176223_P().func_177226_a((IProperty)BlockAetherGrass.PROPERTY_VARIANT, (Comparable)BlockAetherGrass.AETHER);
    }

    @Override
    public IBlockState getCoastalBlock() {
        return BlocksAether.quicksoil.func_176223_P();
    }

    @Override
    public IIslandGenerator createIslandGenerator(Random rand, IIslandData islandData) {
        return new IslandGeneratorForgottenHighlands();
    }

    @Override
    public Collection<NBT> createIslandComponents(IIslandData islandData) {
        return Collections.emptyList();
    }

    @Override
    public float getRarityWeight() {
        return 0.75f;
    }

    @Override
    public void postDecorate(World world, Random rand, BlockPos pos) {
    }

    @Override
    public List<WorldDecoration> createBasicDecorations(Random rand) {
        ArrayList decorations = Lists.newArrayList();
        decorations.add(new WorldDecorationSimple(6, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.short_aether_grass, GenerationAether.aether_grass, GenerationAether.long_aether_grass));
        decorations.add(new WorldDecorationSimple(1, 0.2f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.skyroot_twigs));
        ArrayList flowers = Lists.newArrayList();
        flowers.addAll(GenUtil.GENERAL_FLOWER_STATES);
        decorations.add(GenUtil.createFlowerDecorations(rand, flowers, Lists.newArrayList((Object[])new IBlockState[]{BlocksAether.forgotten_rose.func_176223_P()})));
        decorations.add(GenUtil.createShroomDecorations(GenUtil.SHROOM_STATES));
        decorations.add(new WorldDecorationSimple(6, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerLevels(0, 128), GenerationAether.holystone_rocks));
        return decorations;
    }

    @Override
    public List<WorldDecoration> createTreeDecorations(Random rand) {
        ArrayList treeDecorations = Lists.newArrayList();
        treeDecorations.add(new WorldDecorationSimple(6, 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(GenerationAether.SKYROOT_OAK_GREEN)));
        treeDecorations.add(new WorldDecorationSimple(1, 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(GenerationAether.AMBEROOT_TREE)));
        return treeDecorations;
    }

    @Override
    public float createForestTreeCountModifier(Random rand) {
        if (rand.nextInt(30) == 0) {
            return 0.1f + rand.nextFloat() * 0.9f;
        }
        return 0.75f + rand.nextFloat() * 0.25f;
    }

    @Override
    public float createOpenAreaDecorationGenChance(Random rand) {
        return 0.15f * rand.nextFloat();
    }
}

