/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes.arctic_peaks;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.decoration.WorldDecorationSimple;
import com.gildedgames.aether.api.world.generation.BlueprintWorldGen;
import com.gildedgames.aether.api.world.generation.positioners.PositionerLevels;
import com.gildedgames.aether.api.world.generation.positioners.PositionerSurface;
import com.gildedgames.aether.api.world.islands.IIslandBounds;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.islands.IIslandGenerator;
import com.gildedgames.aether.api.world.noise.IChunkNoiseBuffer2D;
import com.gildedgames.aether.common.blocks.IBlockSnowy;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.init.GenerationAether;
import com.gildedgames.aether.common.util.helpers.IslandHelper;
import com.gildedgames.aether.common.world.WorldProviderAether;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.biomes.ISnowyBiome;
import com.gildedgames.aether.common.world.island.IslandVariables;
import com.gildedgames.aether.common.world.island.generators.IslandGeneratorHighlands;
import com.gildedgames.aether.common.world.noise.ChunkDataGenerator2DSingle;
import com.gildedgames.aether.common.world.noise.NoiseSampleData2D;
import com.gildedgames.aether.common.world.noise.impl.NoiseGeneratorIslandTerrain;
import com.gildedgames.aether.common.world.util.GenUtil;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeArcticPeaks
extends BiomeAetherBase
implements ISnowyBiome {
    public BiomeArcticPeaks(Biome.BiomeProperties properties, ResourceLocation registryName) {
        super(properties, registryName);
        this.field_76752_A = BlocksAether.aether_grass.func_176223_P().func_177226_a((IProperty)BlockAetherGrass.PROPERTY_VARIANT, (Comparable)BlockAetherGrass.ARCTIC);
    }

    @Override
    public IBlockState getCoastalBlock() {
        return BlocksAether.highlands_packed_ice.func_176223_P();
    }

    @Override
    public IIslandGenerator createIslandGenerator(Random rand, IIslandData islandData) {
        int coastHeight = 1 + rand.nextInt(3);
        double coastSpread = rand.nextDouble() * 0.6;
        if (coastHeight == 0) {
            coastSpread = 0.0;
        }
        double mountainAmplitude = 4.0;
        boolean hasTerraces = rand.nextInt(30) == 0;
        int maxTerrainHeight = 80 + rand.nextInt(70);
        return new IslandGeneratorHighlands(IslandVariables.build().coastHeight(coastHeight).coastSpread(coastSpread).lakeBlendRange(0.05 + rand.nextDouble() * 0.5).lakeDepth(rand.nextInt(40) + 5).lakeScale(40.0 + rand.nextDouble() * 30.0).lakeThreshold(rand.nextDouble() * 0.3).maxTerrainHeight(maxTerrainHeight).terraces(hasTerraces).lakeConcentrationModifier(0.5 + rand.nextDouble() * -2.5).heightSampleFilter(heightSample -> Math.min(1.1, Math.pow(heightSample, mountainAmplitude) * 0.55)).snowCaps(!hasTerraces).maxYFilter((bottomMaxY, filteredSample, cutoffPoint) -> bottomMaxY + (filteredSample - (hasTerraces ? cutoffPoint : 0.0)) * (double)maxTerrainHeight).lakeBottomValueFilter(lakeBottomValue -> 0.0));
    }

    @Override
    public Collection<NBT> createIslandComponents(IIslandData islandData) {
        return Collections.emptyList();
    }

    @Override
    public float getRarityWeight() {
        return 1.0f;
    }

    @Override
    public void postDecorate(World world, Random rand, BlockPos pos) {
        int chunkZ;
        int chunkX = pos.func_177958_n() >> 4;
        IIslandData island = IslandHelper.get(world, chunkX, chunkZ = pos.func_177952_p() >> 4);
        if (island == null) {
            return;
        }
        WorldProviderAether provider = WorldProviderAether.get(world);
        IIslandBounds bounds = island.getBounds();
        IChunkNoiseBuffer2D samples = ((NoiseSampleData2D)new ChunkDataGenerator2DSingle(new NoiseGeneratorIslandTerrain(provider.getNoise(), bounds), 4).generate(chunkX, chunkZ)).createInterpolatedNoiseBuffer();
        int posX = pos.func_177958_n() + 8;
        int posZ = pos.func_177952_p() + 8;
        double centerX = island.getBounds().getCenterX();
        double centerZ = island.getBounds().getCenterZ();
        double radiusX = (double)island.getBounds().getWidth() / 2.0;
        double radiusZ = (double)island.getBounds().getLength() / 2.0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos p = new BlockPos(posX + x, 0, posZ + z);
                if (!world.func_175667_e(p)) continue;
                int worldX = posX + x;
                int worldZ = posZ + z;
                double distX = Math.abs((centerX - (double)worldX) * (1.0 / radiusX));
                double distZ = Math.abs((centerZ - (double)worldZ) * (1.0 / radiusZ));
                double dist = Math.sqrt(distX * distX + distZ * distZ) / 1.0;
                double sample = samples.get(x, z);
                double heightSample = sample + 1.0 - dist;
                BlockPos blockpos1 = p.func_177982_a(0, world.func_189649_b(posX + x, posZ + z), 0);
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (world.func_175675_v(blockpos2)) {
                    world.func_180501_a(blockpos2, BlocksAether.highlands_ice.func_176223_P(), 18);
                }
                if (!(heightSample > 0.5)) continue;
                IBlockState state = world.func_180495_p(blockpos1);
                Block block = state.func_177230_c();
                if (world.func_175708_f(blockpos1, true)) {
                    world.func_180501_a(blockpos1, BlocksAether.highlands_snow_layer.func_176223_P(), 18);
                    continue;
                }
                if (!(block instanceof IBlockSnowy)) continue;
                IBlockState newState = state.func_177226_a((IProperty)IBlockSnowy.PROPERTY_SNOWY, (Comparable)Boolean.TRUE);
                world.func_180501_a(blockpos1, newState, 18);
            }
        }
    }

    @Override
    public List<WorldDecoration> createBasicDecorations(Random rand) {
        ArrayList decorations = Lists.newArrayList();
        decorations.add(new WorldDecorationSimple(2, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.short_aether_grass));
        decorations.add(new WorldDecorationSimple(1, 0.2f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerSurface(), GenerationAether.skyroot_twigs));
        ArrayList flowers = Lists.newArrayList();
        flowers.addAll(GenUtil.GENERAL_FLOWER_STATES);
        decorations.add(GenUtil.createFlowerDecorations(rand, flowers, Lists.newArrayList((Object[])new IBlockState[]{BlocksAether.arctic_spikespring.func_176223_P()})));
        decorations.add(GenUtil.createShroomDecorations(GenUtil.SHROOM_STATES));
        decorations.add(new WorldDecorationSimple(6, 0.0f, DecorateBiomeEvent.Decorate.EventType.GRASS, new PositionerLevels(0, 128), GenerationAether.holystone_rocks));
        decorations.add(new WorldDecorationSimple(2, 0.5f, DecorateBiomeEvent.Decorate.EventType.CUSTOM, new PositionerLevels(26, 90), GenerationAether.ice_crystals));
        return decorations;
    }

    @Override
    public List<WorldDecoration> createTreeDecorations(Random rand) {
        ArrayList treeDecorations = Lists.newArrayList();
        BlueprintDefinition[] forest = new BlueprintDefinition[]{GenerationAether.SKYROOT_OAK_DARK_BLUE, GenerationAether.SKYROOT_OAK_BLUE};
        BlueprintDefinition[] neopolitan = new BlueprintDefinition[]{GenerationAether.SKYROOT_OAK_DARK_BLUE, GenerationAether.SKYROOT_OAK_BLUE, GenerationAether.WISPROOT_BLUE, GenerationAether.WISPROOT_DARK_BLUE};
        BlueprintDefinition[] chosen = rand.nextBoolean() ? neopolitan : forest;
        int amountOfTreeTypes = 2 + rand.nextInt(4);
        for (int i = 0; i < amountOfTreeTypes; ++i) {
            treeDecorations.add(new WorldDecorationSimple(15, 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(chosen[rand.nextInt(chosen.length)])));
        }
        treeDecorations.add(new WorldDecorationSimple(20, 0.0f, DecorateBiomeEvent.Decorate.EventType.TREE, new PositionerSurface(), new BlueprintWorldGen(GenerationAether.GREATROOT_TREE)));
        return treeDecorations;
    }

    @Override
    public float createForestTreeCountModifier(Random rand) {
        if (rand.nextInt(30) == 0) {
            return 0.1f + rand.nextFloat() * 0.9f;
        }
        return 0.75f + rand.nextFloat() * 0.25f;
    }

    @Override
    public float createOpenAreaDecorationGenChance(Random rand) {
        return 0.15f * rand.nextFloat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 11320038;
    }
}

