/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes;

import com.gildedgames.aether.api.registrar.BiomesAether;
import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.api.world.preparation.IPrepSector;
import com.gildedgames.aether.api.world.preparation.IPrepSectorAccess;
import com.gildedgames.aether.common.world.aether.PrepSectorDataAether;
import com.gildedgames.aether.common.world.preparation.PrepHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderAether
extends BiomeProvider {
    public static final ArrayList<Biome> allowedBiomes = Lists.newArrayList((Object[])new Biome[]{BiomesAether.VOID, BiomesAether.HIGHLANDS, BiomesAether.MAGNETIC_HILLS});
    private final ThreadLocal<BiomeCache> cache = ThreadLocal.withInitial(() -> new BiomeCache((BiomeProvider)this));
    private final World world;

    public BiomeProviderAether(World world) {
        this.world = world;
    }

    public List<Biome> func_76932_a() {
        return allowedBiomes;
    }

    public void func_76938_b() {
        this.cache.get().func_76838_a();
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, BiomesAether.VOID);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.cache.get().func_180284_a(pos.func_177958_n(), pos.func_177952_p(), BiomesAether.VOID);
    }

    private Biome[] generateBiomes(Biome[] biomes, int x, int z, int width, int height) {
        Arrays.fill(biomes, BiomesAether.VOID);
        if (this.world.field_72995_K) {
            return biomes;
        }
        IPrepManager manager = PrepHelper.getManager(this.world);
        if (manager == null) {
            return biomes;
        }
        IPrepSectorAccess access = manager.getAccess();
        IPrepSector cachedSector = null;
        int prevChunkX = 0;
        int prevChunkY = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int index = j + i * width;
                int posX = i + x;
                int posZ = j + z;
                int chunkX = Math.floorDiv(posX, 16);
                int chunkY = Math.floorDiv(posZ, 16);
                if (chunkX != prevChunkX || chunkY != prevChunkY || cachedSector == null) {
                    cachedSector = access.getLoadedSectorForChunk(chunkX, chunkY).orElse(null);
                    prevChunkX = chunkX;
                    prevChunkY = chunkY;
                }
                if (cachedSector == null || !(cachedSector.getData() instanceof PrepSectorDataAether)) continue;
                PrepSectorDataAether sectorDataAether = (PrepSectorDataAether)cachedSector.getData();
                biomes[index] = sectorDataAether.getIslandData().getBiome();
            }
        }
        return biomes;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        this.generateBiomes(biomes, x, z, width, height);
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] listToReuse, int x, int z, int width, int length) {
        return this.func_76931_a(listToReuse, x, z, width, length, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.cache.get().func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        this.generateBiomes(listToReuse, x, z, width, length);
        return listToReuse;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        for (Biome biome : biomes) {
            if (allowedBiomes.contains(biome)) continue;
            return null;
        }
        return new BlockPos(x - range + random.nextInt(range * 2 + 1), 0, z - range + random.nextInt(range * 2 + 1));
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        for (Biome biome : allowed) {
            if (allowedBiomes.contains(biome)) continue;
            return false;
        }
        return true;
    }
}

