/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.biomes;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.decoration.WorldDecorationUtil;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.templates.TemplateLoc;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.blocks.natural.BlockAercloud;
import com.gildedgames.aether.common.blocks.natural.BlockAetherDirt;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherFlower;
import com.gildedgames.aether.common.blocks.natural.plants.BlockBlueberryBush;
import com.gildedgames.aether.common.blocks.natural.plants.BlockValkyrieGrass;
import com.gildedgames.aether.common.init.GenerationAether;
import com.gildedgames.aether.common.util.helpers.IslandHelper;
import com.gildedgames.aether.common.world.WorldProviderAether;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.decorations.WorldGenAetherMinable;
import com.gildedgames.aether.common.world.decorations.aerclouds.WorldGenAercloud;
import com.gildedgames.aether.common.world.decorations.aerclouds.WorldGenPurpleAercloud;
import com.gildedgames.aether.common.world.decorations.plants.WorldGenBrettlPlant;
import com.gildedgames.aether.common.world.decorations.plants.WorldGenFoliage;
import com.gildedgames.aether.common.world.decorations.trees.WorldGenOrangeTree;
import com.gildedgames.aether.common.world.island.BlockAccessIsland;
import com.gildedgames.aether.common.world.templates.TemplatePlacer;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.BlueprintDefinitionPool;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.util.BlueprintPlacer;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRegion;
import com.gildedgames.orbis.lib.processing.DataPrimer;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeAetherDecorator {
    private final WorldGenAetherMinable genAmbrosium;
    private final WorldGenAetherMinable genZanite;
    private final WorldGenAetherMinable genGravitite;
    private final WorldGenAetherMinable genIcestone;
    private final WorldGenAetherMinable genArkenium;
    private final WorldGenAetherMinable genCoarseAetherDirtOnDirt;
    private final WorldGenAetherMinable genCoarseAetherDirtOnHolystone;
    private final WorldGenAetherMinable genCrudeScatterglass;
    private final WorldGenFoliage genPurpleFlowers;
    private final WorldGenFoliage genWhiteRoses;
    private final WorldGenFoliage genBurstblossom;
    private final WorldGenFoliage genAechorSprout;
    private final WorldGenOrangeTree genOrangeTree;
    private final WorldGenFoliage genBlueberryBushes;
    private final WorldGenFoliage genValkyrieGrass;
    private final WorldGenFoliage genPlumproots;
    private final WorldGenAercloud genColdColumbusAercloud;
    private final WorldGenAercloud genBlueAercloud;
    private final WorldGenAercloud genGreenAercloud;
    private final WorldGenAercloud genGoldAercloud;
    private final WorldGenAercloud genStormAercloud;
    private final WorldGenPurpleAercloud genPurpleAercloud;
    private final WorldGenBrettlPlant genBrettlPlant;
    public final boolean generateBushes = true;

    public BiomeAetherDecorator() {
        IBlockState[] dirtStates = new IBlockState[]{BlocksAether.aether_dirt.func_176223_P()};
        IBlockState[] holystoneStates = new IBlockState[]{BlocksAether.holystone.func_176223_P()};
        this.genAmbrosium = new WorldGenAetherMinable(BlocksAether.ambrosium_ore.func_176223_P(), 16, holystoneStates);
        this.genZanite = new WorldGenAetherMinable(BlocksAether.zanite_ore.func_176223_P(), 8, holystoneStates);
        this.genGravitite = new WorldGenAetherMinable(BlocksAether.gravitite_ore.func_176223_P(), 5, holystoneStates);
        this.genIcestone = new WorldGenAetherMinable(BlocksAether.icestone_ore.func_176223_P(), 12, holystoneStates);
        this.genArkenium = new WorldGenAetherMinable(BlocksAether.arkenium_ore.func_176223_P(), 6, holystoneStates);
        this.genAmbrosium.setEmitsLight(true);
        this.genGravitite.setFloating(true);
        this.genCoarseAetherDirtOnDirt = new WorldGenAetherMinable(BlocksAether.aether_dirt.func_176223_P().func_177226_a((IProperty)BlockAetherDirt.PROPERTY_VARIANT, (Comparable)BlockAetherDirt.COARSE_DIRT), 22, dirtStates);
        this.genCoarseAetherDirtOnHolystone = new WorldGenAetherMinable(BlocksAether.aether_dirt.func_176223_P().func_177226_a((IProperty)BlockAetherDirt.PROPERTY_VARIANT, (Comparable)BlockAetherDirt.COARSE_DIRT), 22, holystoneStates);
        this.genCrudeScatterglass = new WorldGenAetherMinable(BlocksAether.crude_scatterglass.func_176223_P(), 16, holystoneStates);
        this.genPurpleFlowers = new WorldGenFoliage(64, BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.PURPLE_FLOWER));
        this.genWhiteRoses = new WorldGenFoliage(64, BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.WHITE_ROSE));
        this.genBurstblossom = new WorldGenFoliage(64, BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.BURSTBLOSSOM));
        this.genAechorSprout = new WorldGenFoliage(4, BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.AECHOR_SPROUT));
        this.genOrangeTree = new WorldGenOrangeTree();
        this.genBlueberryBushes = new WorldGenFoliage(32, BlocksAether.blueberry_bush.func_176223_P().func_177226_a((IProperty)BlockBlueberryBush.PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)));
        this.genValkyrieGrass = new WorldGenFoliage(64, BlocksAether.valkyrie_grass.func_176223_P().func_177226_a((IProperty)BlockValkyrieGrass.PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockValkyrieGrass.PROPERTY_VARIANT, (Comparable)BlockValkyrieGrass.FULL));
        this.genPlumproots = new WorldGenFoliage(64, BlocksAether.plumproot.func_176223_P());
        this.genBrettlPlant = new WorldGenBrettlPlant();
        this.genColdColumbusAercloud = new WorldGenAercloud(BlockAercloud.getAercloudState(BlockAercloud.COLD_AERCLOUD), 16, false);
        this.genBlueAercloud = new WorldGenAercloud(BlockAercloud.getAercloudState(BlockAercloud.BLUE_AERCLOUD), 8, false);
        this.genGreenAercloud = new WorldGenAercloud(BlockAercloud.getAercloudState(BlockAercloud.GREEN_AERCLOUD), 8, false);
        this.genGoldAercloud = new WorldGenAercloud(BlockAercloud.getAercloudState(BlockAercloud.GOLDEN_AERCLOUD), 8, false);
        this.genStormAercloud = new WorldGenAercloud(BlockAercloud.getAercloudState(BlockAercloud.STORM_AERCLOUD), 8, false);
        this.genPurpleAercloud = new WorldGenPurpleAercloud(BlockAercloud.getAercloudState(BlockAercloud.PURPLE_AERCLOUD), 4, false);
    }

    public void prepareDecorationsWholeIsland(World world, BlockAccessIsland access, IIslandData island, Random random) {
        DataPrimer primer = new DataPrimer((IBlockAccessExtended)access);
        int startX = island.getBounds().getMinX();
        int startZ = island.getBounds().getMinZ();
        boolean generated = false;
        BlueprintDefinition outpostDef = GenerationAether.OUTPOST.getRandomDefinition(random);
        Rotation rotation = outpostDef.hasRandomRotation() ? BlueprintPlacer.ROTATIONS[world.field_73012_v.nextInt(BlueprintPlacer.ROTATIONS.length)] : BlueprintPlacer.ROTATIONS[0];
        BakedBlueprint outpostBake = new BakedBlueprint(outpostDef, (ICreationData)new CreationData(world).seed(random.nextLong()).rotation(rotation));
        for (int i = 0; i < 10000; ++i) {
            BlockPos pos;
            int y;
            int z;
            int x = random.nextInt(island.getBounds().getWidth());
            if (!access.canAccess(startX + x, startZ + (z = random.nextInt(island.getBounds().getLength()))) || (y = access.getTopY(startX + x, startZ + z)) <= 0 || !(generated = primer.canGenerate(outpostBake, pos = new BlockPos(startX + x, y, startZ + z)))) continue;
            PlacedBlueprint placed = island.placeBlueprint(outpostBake, pos);
            ScheduleRegion trigger = placed.getBaked().getScheduleFromTriggerID("spawn");
            if (trigger == null) break;
            island.setOutpostPos(trigger.getBounds().getMin().func_177971_a((Vec3i)pos));
            break;
        }
        if (!generated) {
            AetherCore.LOGGER.info("WARNING: OUTPOST NOT GENERATED ON AN ISLAND!");
        }
        this.generate(GenerationAether.WELL, 100, random.nextInt(8), island, (IBlockAccessExtended)access, primer, world, random);
        this.generate(GenerationAether.ABAND_ANGEL_STOREROOM, 100, random.nextInt(10), island, (IBlockAccessExtended)access, primer, world, random);
        this.generate(GenerationAether.ABAND_ANGEL_WATCHTOWER, 100, random.nextInt(10), island, (IBlockAccessExtended)access, primer, world, random);
        this.generate(GenerationAether.ABAND_CAMPSITE, 100, 5, island, (IBlockAccessExtended)access, primer, world, random);
        this.generate(GenerationAether.ABAND_HUMAN_HOUSE, 100, random.nextInt(10), island, (IBlockAccessExtended)access, primer, world, random);
        this.generate(GenerationAether.SKYROOT_WATCHTOWER, 100, random.nextInt(10), island, (IBlockAccessExtended)access, primer, world, random);
    }

    private void generate(BlueprintDefinition def, int tries, int maxGenerated, IIslandData island, IBlockAccessExtended access, DataPrimer primer, World world, Random rand) {
        if (maxGenerated <= 0) {
            return;
        }
        Rotation rotation = def.hasRandomRotation() ? BlueprintPlacer.ROTATIONS[rand.nextInt(BlueprintPlacer.ROTATIONS.length)] : BlueprintPlacer.ROTATIONS[0];
        BakedBlueprint baked = new BakedBlueprint(def, (ICreationData)new CreationData(world).rotation(rotation));
        int amountGenerated = 0;
        int startX = island.getBounds().getMinX();
        int startZ = island.getBounds().getMinZ();
        for (int i = 0; i < tries; ++i) {
            BlockPos pos;
            boolean generated;
            int y;
            int z;
            int x = rand.nextInt(island.getBounds().getWidth());
            if (!access.canAccess(startX + x, startZ + (z = rand.nextInt(island.getBounds().getLength()))) || (y = access.getTopY(startX + x, startZ + z) - def.getFloorHeight() + (def.getFloorHeight() == 0 ? 1 : 0)) < 80 || !(generated = primer.canGenerate(baked, pos = new BlockPos(startX + x, y, startZ + z)))) continue;
            island.placeBlueprint(baked, pos);
            rotation = def.hasRandomRotation() ? BlueprintPlacer.ROTATIONS[rand.nextInt(BlueprintPlacer.ROTATIONS.length)] : BlueprintPlacer.ROTATIONS[0];
            baked = new BakedBlueprint(def, (ICreationData)new CreationData(world).rotation(rotation));
            if (++amountGenerated < maxGenerated) continue;
            return;
        }
    }

    private void generate(BlueprintDefinitionPool pool, int tries, int maxGenerated, IIslandData island, IBlockAccessExtended access, DataPrimer primer, World world, Random rand) {
        if (maxGenerated <= 0) {
            return;
        }
        BlueprintDefinition def = pool.getRandomDefinition(rand);
        this.generate(def, tries, maxGenerated, island, access, primer, world, rand);
    }

    protected void genDecorations(World world, Random random, BlockPos pos, Biome genBase) {
        int x;
        IIslandData island;
        ChunkPos chunkPos = new ChunkPos(pos);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        WorldSlice slice = new WorldSlice(world, chunkPos);
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            this.generateOres(slice, random, pos);
        }
        if ((island = IslandHelper.get(world, chunkPos.field_77276_a, chunkPos.field_77275_b)) == null) {
            return;
        }
        WorldDecorationUtil.generateDecorations(island.getBasicDecorations(), world, random, pos);
        WorldProviderAether provider = WorldProviderAether.get(world);
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            WorldDecorationUtil.generateDecorationsWithNoise(island.getTreeDecorations(), world, random, pos, provider.getNoise(), island.getOpenAreaDecorationGenChance(), island.getForestTreeCountModifier());
        }
        BlockPos.PooledMutableBlockPos randomPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && random.nextInt(4) == 0) {
            x = random.nextInt(16) + 8;
            int z = random.nextInt(16) + 8;
            BlockPos pos2 = world.func_175672_r(pos.func_177982_a(x, 0, z)).func_177982_a(0, -1, 0);
            TemplatePlacer.place(world, GenerationAether.skyroot_moa_nest.getRandomDefinition(random), new TemplateLoc().set(pos2), random);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            for (int count = 0; count < 3; ++count) {
                int x2 = random.nextInt(16) + 8;
                int y = random.nextInt(180) + 64;
                int z = random.nextInt(16) + 8;
                this.genOrangeTree.func_180709_b(world, random, BiomeAetherDecorator.translate(randomPos, pos, x2, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            this.getClass();
            this.generateFoliage(this.genBlueberryBushes, slice, random, pos, 15);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            this.generateFoliage(this.genPurpleFlowers, slice, random, pos, 5);
            this.generateFoliage(this.genWhiteRoses, slice, random, pos, 5);
            this.generateFoliage(this.genBurstblossom, slice, random, pos, 5);
            this.generateFoliage(this.genAechorSprout, slice, random, pos, 5);
            this.generateFoliage(this.genValkyrieGrass, slice, random, pos, 5);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            this.generateFoliage(this.genAechorSprout, slice, random, pos, 5);
            this.generateFoliage(this.genValkyrieGrass, slice, random, pos, 5);
            if (random.nextInt(5) == 0) {
                x = random.nextInt(16) + 8;
                int y = random.nextInt(180) + 64;
                int z = random.nextInt(16) + 8;
                this.genBrettlPlant.func_180709_b(world, random, BiomeAetherDecorator.translate(randomPos, pos, x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            this.generateFoliage(this.genPlumproots, slice, random, pos, 50);
        }
        randomPos.func_185344_t();
        this.generateClouds(slice, random, new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        if (genBase instanceof BiomeAetherBase) {
            BiomeAetherBase aetherBiome = (BiomeAetherBase)genBase;
            aetherBiome.postDecorate(world, random, pos);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    private void generateFoliage(WorldGenFoliage gen, WorldSlice slice, Random random, BlockPos pos, int chance) {
        if (random.nextInt(chance) == 0) {
            int x = pos.func_177958_n() + random.nextInt(16) + 8;
            int z = pos.func_177952_p() + random.nextInt(16) + 8;
            gen.generate(slice, random, x, z);
        }
    }

    private void generateMinable(WorldGenAetherMinable minable, WorldSlice slice, Random random, BlockPos pos, int maxY, int attempts) {
        double attemptsPerLevel = (double)attempts / (double)maxY;
        int topY = Math.max(slice.getWorld().func_175672_r(pos).func_177956_o() + 8, 255);
        if (topY <= 0) {
            return;
        }
        int adjustedMaxY = Math.min(topY, maxY);
        if (adjustedMaxY < 0) {
            return;
        }
        int bottomY = Math.min(BiomeAetherDecorator.getBottomSolidOrLiquidBlock(slice.getWorld(), pos).func_177956_o() - 8, 0);
        if (adjustedMaxY <= bottomY) {
            return;
        }
        double adjustedAttempts = (double)(adjustedMaxY - bottomY) * attemptsPerLevel;
        BlockPos.PooledMutableBlockPos randomPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int count = 0;
        while ((double)count < adjustedAttempts) {
            BiomeAetherDecorator.translate(randomPos, pos, random.nextInt(16), random.nextInt(adjustedMaxY - bottomY) + bottomY, random.nextInt(16));
            minable.generate(slice, random, (BlockPos)randomPos);
            ++count;
        }
        randomPos.func_185344_t();
    }

    private void generateCloud(WorldGenAercloud gen, WorldSlice slice, BlockPos pos, Random rand, int rarity, int width, int minY, int maxY) {
        BlockPos.PooledMutableBlockPos randomPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (rand.nextInt(rarity) == 0) {
            BiomeAetherDecorator.translate(randomPos, pos, rand.nextInt(width), minY + rand.nextInt(maxY - minY), rand.nextInt(width));
            gen.generate(slice, rand, (BlockPos)randomPos);
        }
        randomPos.func_185344_t();
    }

    protected int nextInt(Random random, int i) {
        if (i <= 1) {
            return 0;
        }
        return random.nextInt(i);
    }

    private static BlockPos translate(BlockPos.PooledMutableBlockPos pos, BlockPos origin, int x, int y, int z) {
        return pos.func_181079_c(origin.func_177958_n() + x, origin.func_177956_o() + y, origin.func_177952_p() + z);
    }

    protected void generateOres(WorldSlice slice, Random random, BlockPos pos) {
        this.generateMinable(this.genAmbrosium, slice, random, pos, 256, 10);
        this.generateMinable(this.genZanite, slice, random, pos, 256, 9);
        this.generateMinable(this.genGravitite, slice, random, pos, 50, 5);
        this.generateMinable(this.genIcestone, slice, random, pos, 256, 10);
        this.generateMinable(this.genArkenium, slice, random, pos, 70, 8);
        this.generateMinable(this.genCrudeScatterglass, slice, random, pos, 110, 14);
    }

    protected void generateClouds(WorldSlice world, Random random, BlockPos pos) {
        this.generateCloud(this.genStormAercloud, world, pos, random, 30, 16, 238, 256);
        this.generateCloud(this.genPurpleAercloud, world, pos, random, 50, 4, 226, 246);
        this.generateCloud(this.genBlueAercloud, world, pos, random, 50, 16, 218, 236);
        this.generateCloud(this.genColdColumbusAercloud, world, pos, random, 15, 16, 190, 230);
        this.generateCloud(this.genGreenAercloud, world, pos, random, 50, 16, 208, 226);
        this.generateCloud(this.genGoldAercloud, world, pos, random, 50, 16, 185, 205);
        this.generateCloud(this.genColdColumbusAercloud, world, pos, random, 15, 16, 110, 150);
        this.generateCloud(this.genGreenAercloud, world, pos, random, 50, 16, 100, 110);
        this.generateCloud(this.genPurpleAercloud, world, pos, random, 50, 4, 90, 100);
        this.generateCloud(this.genBlueAercloud, world, pos, random, 50, 16, 85, 95);
        this.generateCloud(this.genStormAercloud, world, pos, random, 15, 16, 40, 55);
        this.generateCloud(this.genGreenAercloud, world, pos, random, 30, 16, 25, 35);
        this.generateCloud(this.genGoldAercloud, world, pos, random, 30, 16, 12, 24);
        this.generateCloud(this.genBlueAercloud, world, pos, random, 30, 16, 5, 15);
    }

    private static BlockPos getBottomSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        int lowestSection = -1;
        for (int i = 0; i < chunk.func_76587_i().length; ++i) {
            if (chunk.func_76587_i()[i] == Chunk.field_186036_a) continue;
            lowestSection = i * 16;
            break;
        }
        if (lowestSection == -1) {
            return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), lowestSection, pos.func_177952_p());
        while (blockpos.func_177956_o() <= 255 && (!(state = chunk.func_177435_g(blockpos1 = blockpos.func_177984_a())).func_185904_a().func_76230_c() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos1) || state.func_177230_c().isFoliage((IBlockAccess)world, blockpos1))) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

