/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.aether;

import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.island.IslandData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PrepSectorDataAether
implements IPrepSectorData {
    private boolean dirty;
    private final World world;
    private int sectorX;
    private int sectorY;
    private long seed;
    private IIslandData islandData;

    public PrepSectorDataAether(World world, int sectorX, int sectorY) {
        this.world = world;
        this.sectorX = sectorX;
        this.sectorY = sectorY;
    }

    public PrepSectorDataAether(World world, NBTTagCompound tag) {
        this.world = world;
        this.read(tag);
    }

    public IIslandData getIslandData() {
        return this.islandData;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public int getSectorX() {
        return this.sectorX;
    }

    @Override
    public int getSectorY() {
        return this.sectorY;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("x", this.sectorX);
        tag.func_74768_a("y", this.sectorY);
        tag.func_74772_a("s", this.seed);
        NBTTagCompound islandTag = new NBTTagCompound();
        this.islandData.write(islandTag);
        tag.func_74782_a("island", (NBTBase)islandTag);
    }

    public void read(NBTTagCompound tag) {
        this.sectorX = tag.func_74762_e("x");
        this.sectorY = tag.func_74762_e("y");
        this.seed = tag.func_74763_f("s");
        this.islandData = new IslandData(this, tag.func_74775_l("island"));
    }

    public void setIslandData(IIslandData island) {
        this.islandData = island;
    }

    public void tick() {
        this.islandData.tick();
    }
}

