/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.aether;

import com.gildedgames.aether.api.registrar.BiomesAether;
import com.gildedgames.aether.api.world.IChunkInfoAether;
import com.gildedgames.aether.api.world.islands.IIslandChunkInfo;
import com.gildedgames.aether.api.world.islands.IIslandData;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.init.BiomesAetherInit;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.world.aether.ChunkInfoAether;
import com.gildedgames.aether.common.world.aether.PrepSectorDataAether;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.generators.ChunkGeneratorAether;
import com.gildedgames.aether.common.world.island.BlockAccessIsland;
import com.gildedgames.aether.common.world.island.IslandBounds;
import com.gildedgames.aether.common.world.island.IslandChunkMaskTransformer;
import com.gildedgames.aether.common.world.island.IslandData;
import com.gildedgames.orbis.lib.util.random.XoRoShiRoRandom;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;

public class PrepAether
implements IPrepRegistryEntry<IChunkInfoAether> {
    public static final ResourceLocation UNIQUE_ID = AetherCore.getResource("islands");
    private final IslandChunkMaskTransformer chunkMaskTransformer = new IslandChunkMaskTransformer();

    @Override
    public ResourceLocation getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public int getSectorChunkArea() {
        return 60;
    }

    @Override
    public boolean shouldAttachTo(World world) {
        return world.field_73011_w.func_186058_p() == DimensionsAether.AETHER;
    }

    @Override
    public void postSectorDataCreate(World world, IPrepSectorData sectorData) {
        PrepSectorDataAether sectorDataAether;
        IIslandData islandData;
        Biome biome;
        if (sectorData instanceof PrepSectorDataAether && (biome = (islandData = (sectorDataAether = (PrepSectorDataAether)sectorData).getIslandData()).getBiome()) instanceof BiomeAetherBase) {
            BiomeAetherBase biomeAether = (BiomeAetherBase)biome;
            islandData.addComponents(biomeAether.createIslandComponents(islandData));
            biomeAether.getBiomeDecorator().prepareDecorationsWholeIsland(world, new BlockAccessIsland(world, islandData, sectorData, this), islandData, (Random)new XoRoShiRoRandom(islandData.getSeed()));
        }
    }

    @Override
    public IPrepSectorData createData(World world, long seed, int sectorX, int sectorY) {
        int sectorArea = this.getSectorChunkArea() * 16;
        int width = 960;
        int height = 255;
        int length = 960;
        int x = sectorArea * sectorX;
        boolean y = false;
        int z = sectorArea * sectorY;
        IslandBounds bounds = new IslandBounds(x, 0, z, x + 960, 255, z + 960);
        long islandSeed = seed ^ (long)x * 341873128712L + (long)z * 132897987541L;
        Random rand = new Random(islandSeed);
        BiomeAetherBase chosen = sectorX == 0 && sectorY == 0 ? (BiomeAetherBase)BiomesAether.HIGHLANDS : BiomesAetherInit.fetchRandomBiome(rand);
        PrepSectorDataAether data = new PrepSectorDataAether(world, sectorX, sectorY);
        IslandData island = new IslandData(data, bounds, chosen, islandSeed);
        data.setIslandData(island);
        return data;
    }

    @Override
    public IPrepSectorData createDataAndRead(World world, NBTTagCompound tag) {
        return new PrepSectorDataAether(world, tag);
    }

    @Override
    public void threadSafeGenerateMask(IChunkInfoAether info, World world, IPrepSectorData sectorData, IChunkMask mask, int x, int z) {
        IChunkGenerator generator = world.field_73011_w.func_186060_c();
        if (generator instanceof ChunkGeneratorAether && sectorData instanceof PrepSectorDataAether) {
            ChunkGeneratorAether aetherGen = (ChunkGeneratorAether)generator;
            PrepSectorDataAether aetherData = (PrepSectorDataAether)sectorData;
            IIslandData islandData = aetherData.getIslandData();
            aetherGen.generateBaseTerrain(info, mask, islandData, x, z);
        }
    }

    @Override
    public IChunkMaskTransformer createMaskTransformer() {
        return this.chunkMaskTransformer;
    }

    @Override
    public ChunkInfoAether generateChunkColumnInfo(World world, IPrepSectorData sectorData, int chunkX, int chunkZ) {
        IChunkGenerator generator = world.field_73011_w.func_186060_c();
        if (generator instanceof ChunkGeneratorAether && sectorData instanceof PrepSectorDataAether) {
            ChunkGeneratorAether aetherGen = (ChunkGeneratorAether)generator;
            PrepSectorDataAether aetherData = (PrepSectorDataAether)sectorData;
            IIslandData islandData = aetherData.getIslandData();
            IIslandChunkInfo obj = aetherGen.generateChunkColumnInfo(islandData, chunkX, chunkZ);
            ChunkInfoAether info = new ChunkInfoAether(1);
            info.setIslandData(0, obj);
            return info;
        }
        return null;
    }
}

