/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.access;

import com.gildedgames.aether.api.world.preparation.IChunkInfo;
import com.gildedgames.aether.api.world.preparation.IChunkMask;
import com.gildedgames.aether.api.world.preparation.IChunkMaskTransformer;
import com.gildedgames.aether.api.world.preparation.IPrepChunkManager;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSectorData;
import com.gildedgames.aether.common.world.preparation.PrepChunkManager;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public abstract class BlockAccessPrep
implements IBlockAccessExtended {
    protected IChunkMaskTransformer transformer;
    private World world;
    private IPrepChunkManager<? extends IChunkInfo> chunkManager;
    private IPrepSectorData sectorData;

    public BlockAccessPrep(World world, IPrepSectorData sectorData, IPrepRegistryEntry<? extends IChunkInfo> registryEntry) {
        this.world = world;
        this.sectorData = sectorData;
        this.chunkManager = new PrepChunkManager<IChunkInfo>(world, registryEntry);
        this.transformer = this.chunkManager.createMaskTransformer();
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public boolean canAccess(BlockPos pos, int radius) {
        return true;
    }

    public BlockPos getTopPos(BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), this.getTopY(pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
    }

    public int getTopY(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        IChunkMask mask = this.chunkManager.getChunk(this.sectorData, chunkX, chunkZ);
        return mask.getHighestBlock(x & 0xF, z & 0xF);
    }

    public void setBlockToAir(BlockPos pos) {
    }

    public boolean setBlockState(BlockPos pos, IBlockState state) {
        return false;
    }

    public boolean setBlockState(BlockPos pos, IBlockState state, int flags) {
        return false;
    }

    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
    }

    public void spawnEntity(Entity entity) {
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return null;
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IChunkMask chunk = this.getChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return this.transformer.getBlockState(chunk.getBlock(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType func_175624_G() {
        return null;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return false;
    }

    protected IChunkMask getChunk(int x, int z) {
        IChunkMask chunk = this.chunkManager.getChunk(this.sectorData, x, z);
        if (chunk == null) {
            throw new RuntimeException("ChunkMask is null at position: x(" + x + "), z(" + z + ")");
        }
        return chunk;
    }
}

