/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world.access;

import com.gildedgames.aether.common.world.preparation.mask.ChunkDataContainer;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public class BlockAccessChunkDataContainer
implements IBlockAccessExtended {
    private final World world;
    private final ChunkDataContainer container;
    private final int offsetX;
    private final int offsetZ;

    public BlockAccessChunkDataContainer(World world, ChunkDataContainer container) {
        this.world = world;
        this.container = container;
        this.offsetX = this.container.getChunkX() * 16;
        this.offsetZ = this.container.getChunkZ() * 16;
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public boolean canAccess(BlockPos pos) {
        return true;
    }

    public boolean canAccess(BlockPos pos, int radius) {
        return true;
    }

    public boolean canAccess(int x, int z) {
        return true;
    }

    public boolean canAccess(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return true;
    }

    public BlockPos getTopPos(BlockPos pos) {
        return this.world.func_175672_r(pos);
    }

    public int getTopY(int x, int z) {
        return this.world.func_189649_b(x, z);
    }

    public void setBlockToAir(BlockPos pos) {
        this.container.setBlockState(pos.func_177958_n() - this.offsetX, pos.func_177956_o(), pos.func_177952_p() - this.offsetZ, Blocks.field_150350_a.func_176223_P());
    }

    public boolean setBlockState(BlockPos pos, IBlockState state) {
        this.container.setBlockState(pos.func_177958_n() - this.offsetX, pos.func_177956_o(), pos.func_177952_p() - this.offsetZ, state);
        return true;
    }

    public boolean setBlockState(BlockPos pos, IBlockState state, int flags) {
        this.container.setBlockState(pos.func_177958_n() - this.offsetX, pos.func_177956_o(), pos.func_177952_p() - this.offsetZ, state);
        return true;
    }

    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
        this.container.setTileEntity(pos.func_185334_h(), tileEntity);
    }

    public void spawnEntity(Entity entity) {
        this.container.addEntity(entity);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.container.getTileEntity(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.world.func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.container.getBlockState(pos.func_177958_n() - this.offsetX, pos.func_177956_o(), pos.func_177952_p() - this.offsetZ);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos) != Blocks.field_150350_a.func_176223_P();
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.world.isSideSolid(pos, side, _default);
    }
}

