/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.world;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.islands.precipitation.IPrecipitationManager;
import com.gildedgames.aether.client.renderer.world.RenderWorldPrecipitation;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.world.biomes.BiomeProviderAether;
import com.gildedgames.aether.common.world.generators.ChunkGeneratorAether;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderAether
extends WorldProviderSurface {
    private final float[] sunriseSunsetColors = new float[4];
    private OpenSimplexNoise noise;

    public void updateWeather() {
        IPrecipitationManager precip = (IPrecipitationManager)this.field_76579_a.getCapability(CapabilitiesAether.PRECIPITATION_MANAGER, null);
        if (precip != null) {
            precip.tick();
        }
    }

    public WorldProviderAether() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.setupClientRenderer();
        }
    }

    public static WorldProviderAether get(World world) {
        return (WorldProviderAether)world.field_73011_w;
    }

    public OpenSimplexNoise getNoise() {
        return this.noise;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupClientRenderer() {
        this.setWeatherRenderer(new RenderWorldPrecipitation());
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76578_c = new BiomeProviderAether(this.field_76579_a);
        this.noise = new OpenSimplexNoise(this.field_76579_a.func_72905_C());
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return super.getBiomeForCoords(pos);
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorAether(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public BlockPos getTopBlockPos(BlockPos pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        while (!this.field_76579_a.func_175623_d(testPos.func_177984_a())) {
            testPos = testPos.func_189536_c(EnumFacing.UP);
        }
        return testPos;
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        if (pos.func_177956_o() <= 80) {
            return false;
        }
        if (!super.canSnowAt(pos, checkLight)) {
            return false;
        }
        Block down = this.field_76579_a.func_180495_p(pos.func_177977_b()).func_177230_c();
        return down != BlocksAether.highlands_ice && down != BlocksAether.highlands_packed_ice;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return 0;
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos top = this.getTopBlockPos(new BlockPos(x, 0, z));
        return !this.field_76579_a.func_175623_d(top) && this.field_76579_a.func_180495_p(top) == BlocksAether.aether_grass.func_176223_P();
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76569_d() {
        return true;
    }

    public String getSaveFolder() {
        return "AETHER";
    }

    public double getHorizon() {
        return 0.0;
    }

    public DimensionType func_186058_p() {
        return DimensionsAether.AETHER;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float angle, float partialTicks) {
        int color = 13555179;
        float cos = MathHelper.func_76134_b((float)(angle * 3.141593f * 2.0f)) * 2.0f + 0.5f;
        if (cos < 0.0f) {
            cos = 0.0f;
        } else if (cos > 1.0f) {
            cos = 1.0f;
        }
        float red = 0.80784315f;
        float green = 0.8352941f;
        float blue = 0.92156863f;
        return new Vec3d((double)(red *= cos * 0.94f + 0.06f), (double)(green *= cos * 0.94f + 0.06f), (double)(blue *= cos * 0.91f + 0.09f));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float angle, float partialTicks) {
        float f2 = 0.4f;
        float cos = MathHelper.func_76134_b((float)(angle * 3.141593f * 2.0f)) - 0.0f;
        float f4 = -0.0f;
        if (cos >= -0.4f && cos <= 0.4f) {
            float f5 = (cos - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            this.sunriseSunsetColors[0] = f5 * 0.3f + 0.7f;
            this.sunriseSunsetColors[1] = f5 * f5 * 0.7f + 0.2f;
            this.sunriseSunsetColors[2] = f5 * f5 * 0.0f + 0.2f;
            this.sunriseSunsetColors[3] = f6;
            return this.sunriseSunsetColors;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        return 0.03125;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 200.0f;
    }

    public boolean func_186056_c(int x, int z) {
        return true;
    }
}

