/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.util.helpers;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldUtil {
    public static boolean isBlockInAABB(AxisAlignedBB bb, World world, IBlockState state) {
        return WorldUtil.isBlockInAABB(bb, world, state, true);
    }

    public static boolean isBlockInAABB(AxisAlignedBB bb, World world, IBlockState state, boolean checkLoaded) {
        int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int minY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int maxX = MathHelper.func_76143_f((double)bb.field_72336_d);
        int maxY = MathHelper.func_76143_f((double)bb.field_72337_e);
        int maxZ = MathHelper.func_76143_f((double)bb.field_72334_f);
        if (checkLoaded && !world.func_175707_a(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ))) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Chunk chunk = null;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (chunk != null && (chunk.field_76635_g != x >> 4 || chunk.field_76647_h != z >> 4)) {
                    chunk = null;
                }
                if (chunk == null) {
                    chunk = world.func_72964_e(x >> 4, z >> 4);
                }
                for (int y = minY; y < maxY; ++y) {
                    pos.func_181079_c(x, y, z);
                    if (world.func_180495_p((BlockPos)pos) != state) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isBlockBelowAABB(AxisAlignedBB bb, World world, IBlockState block) {
        int maxZ;
        int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)bb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)bb.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (!world.func_175707_a(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ = MathHelper.func_76128_c((double)bb.field_72334_f)))) {
            return false;
        }
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = maxY; y >= 0; --y) {
                    IBlockState state = world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                    if (state == block) {
                        pos.func_185344_t();
                        return true;
                    }
                    if (state != Blocks.field_150350_a.func_176223_P()) continue block1;
                }
            }
        }
        pos.func_185344_t();
        return false;
    }
}

