/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.util.helpers;

import com.gildedgames.aether.api.recipes.simple.ISimpleRecipe;
import com.gildedgames.aether.common.recipes.simple.OreDictionaryRequirement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeUtil {
    private RecipeUtil() {
    }

    public static boolean areEqual(Object obj1, Object obj2) {
        if (obj2 == null || obj1 == null) {
            return false;
        }
        if (obj1 instanceof ItemStack && obj2 instanceof ItemStack) {
            ItemStack stack1 = (ItemStack)obj1;
            ItemStack stack2 = (ItemStack)obj2;
            if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
                return stack2.func_77973_b() == stack1.func_77973_b();
            }
            return ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack2);
        }
        return obj1.equals(obj2) || obj2.equals(obj1);
    }

    public static boolean areEqual(Object obj, ItemStack stack) {
        if (stack == ItemStack.field_190927_a || obj == ItemStack.field_190927_a || stack.func_190926_b() || obj instanceof ItemStack && ((ItemStack)obj).func_190926_b()) {
            return false;
        }
        if (obj instanceof ItemStack) {
            ItemStack otherStack = (ItemStack)obj;
            if (otherStack.func_77952_i() == Short.MAX_VALUE) {
                return otherStack.func_77973_b() == stack.func_77973_b();
            }
            return ItemStack.func_185132_d((ItemStack)((ItemStack)obj), (ItemStack)stack);
        }
        if (obj instanceof OreDictionaryRequirement) {
            OreDictionaryRequirement oreReq = (OreDictionaryRequirement)obj;
            return oreReq.matches(stack);
        }
        if (obj instanceof String) {
            int[] stackIds = OreDictionary.getOreIDs((ItemStack)stack);
            int ore = OreDictionary.getOreID((String)((String)obj));
            for (int id : stackIds) {
                if (ore != id) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEnoughOfMaterial(EntityPlayer player, Object req) {
        if (req == null) {
            return false;
        }
        int amount = 0;
        if (req instanceof ItemStack) {
            amount = ((ItemStack)req).func_190916_E();
        } else if (req instanceof OreDictionaryRequirement) {
            amount = ((OreDictionaryRequirement)req).getCount();
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack inventoryStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!RecipeUtil.areEqual(req, inventoryStack) || (amount = Math.max(0, amount - inventoryStack.func_190916_E())) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canCraft(EntityPlayer player, ISimpleRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        block0: for (int reqIndex = 0; reqIndex < recipe.getRequired().length; ++reqIndex) {
            Object req = recipe.getRequired()[reqIndex];
            int amount = 0;
            if (req instanceof ItemStack) {
                amount = ((ItemStack)req).func_190916_E();
            } else if (req instanceof OreDictionaryRequirement) {
                amount = ((OreDictionaryRequirement)req).getCount();
            }
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack inventoryStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (RecipeUtil.areEqual(req, inventoryStack) && (amount = Math.max(0, amount - inventoryStack.func_190916_E())) <= 0) continue block0;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static int getTotalTimesCanCraft(EntityPlayer player, ISimpleRecipe recipe) {
        if (recipe == null) {
            return 0;
        }
        int totalCount = Integer.MAX_VALUE;
        for (int reqIndex = 0; reqIndex < recipe.getRequired().length; ++reqIndex) {
            Object req = recipe.getRequired()[reqIndex];
            int amount = 0;
            if (req instanceof ItemStack) {
                amount = ((ItemStack)req).func_190916_E();
            } else if (req instanceof OreDictionaryRequirement) {
                amount = ((OreDictionaryRequirement)req).getCount();
            }
            int innerTotalCount = 0;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack inventoryStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (!RecipeUtil.areEqual(req, inventoryStack)) continue;
                innerTotalCount += inventoryStack.func_190916_E();
            }
            totalCount = Math.min(innerTotalCount / amount, totalCount);
        }
        return totalCount;
    }
}

