/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.util.helpers;

import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.client.gui.EffectSystemOverlay;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketStatusParticles;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityUtil {
    public static boolean checkEntityClass(Entity entity, Class<?> clazz) {
        if (entity instanceof MultiPartEntityPart) {
            MultiPartEntityPart multi = (MultiPartEntityPart)entity;
            if (multi.field_70259_a.getClass() != clazz) {
                return false;
            }
        }
        return entity.getClass() == clazz;
    }

    public static <T extends Entity> T clone(T entity) {
        Entity newEnt = EntityList.func_191304_a(entity.getClass(), (World)entity.func_130014_f_());
        if (newEnt != null) {
            newEnt.func_180432_n(entity);
        }
        return (T)newEnt;
    }

    public static void despawnEntityDuringDaytime(EntityLivingBase entity) {
        if (entity.field_70173_aa % 20 == 0) {
            BlockPos blockpos = new BlockPos(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
            if (!entity.field_70170_p.field_72995_K && entity.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) - entity.field_70170_p.func_175657_ab() >= 15 && entity.field_70170_p.func_175710_j(blockpos)) {
                entity.func_70097_a(DamageSource.field_76380_i, 1.0f);
                double x = entity.field_70165_t;
                double y = (entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b) / 2.0 + entity.func_174813_aQ().field_72338_b;
                double z = entity.field_70161_v;
                double motionX = 0.0;
                double motionY = 0.0;
                double motionZ = 0.0;
                for (int i = 0; i < 15; ++i) {
                    EnumParticleTypes type = entity.func_70681_au().nextBoolean() ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
                    double radius = 0.3;
                    double randX = entity.func_70681_au().nextDouble() * (entity.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.3;
                    double randZ = entity.func_70681_au().nextDouble() * (entity.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.3;
                    if (entity.field_70170_p.field_72995_K) {
                        entity.field_70170_p.func_175688_a(type, x + randX, y, z + randZ, 0.0, 0.0, 0.0, new int[0]);
                        continue;
                    }
                    if (!(entity.field_70170_p instanceof WorldServer)) continue;
                    WorldServer worldServer = (WorldServer)entity.field_70170_p;
                    worldServer.func_175739_a(type, x + randX, y, z + randZ, 1, 0.0, 0.0, 0.0, entity.field_70170_p.field_73012_v.nextBoolean() ? 0.01 : -0.01, new int[0]);
                }
            }
        }
    }

    public static Entity getEntityFromUUID(World world, UUID uuid) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public static void facePos(Entity entity, BlockPos pos, float maxYawIncrease, float maxPitchIncrease) {
        EntityUtil.facePos(entity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), maxYawIncrease, maxPitchIncrease);
    }

    public static double getYawFacingPosition(Entity entity, double posX, double posZ) {
        double x = posX - entity.field_70165_t;
        double z = posZ - entity.field_70161_v;
        return MathHelper.func_181159_b((double)z, (double)x) * 57.29577951308232 - 90.0;
    }

    public static void facePos(Entity entity, double posX, double posY, double posZ, float maxYawIncrease, float maxPitchIncrease) {
        double x = posX - entity.field_70165_t;
        double y = posY - entity.field_70163_u;
        double z = posZ - entity.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(x * x + z * z));
        float f = (float)(MathHelper.func_181159_b((double)z, (double)x) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)y, (double)d3) * 57.29577951308232));
        entity.field_70125_A = EntityUtil.updateRotation(entity.field_70125_A, f1, maxPitchIncrease);
        entity.field_70177_z = EntityUtil.updateRotation(entity.field_70177_z, f, maxYawIncrease);
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public static void spawnParticleLineBetween(Entity e1, Entity e2, double density, EnumParticleTypes type, int ... parameters) {
        for (int k = 0; k < 1; ++k) {
            World world = e1.field_70170_p;
            double currentX = e2.field_70165_t;
            double currentY = (e2.func_174813_aQ().field_72337_e - e2.func_174813_aQ().field_72338_b) / 2.0 + e2.func_174813_aQ().field_72338_b;
            double currentZ = e2.field_70161_v;
            double width = e1.func_174813_aQ().field_72336_d - e1.func_174813_aQ().field_72340_a;
            double length1 = e1.func_174813_aQ().field_72334_f - e1.func_174813_aQ().field_72339_c;
            double targetX = e1.func_174813_aQ().field_72340_a + width / 2.0;
            double targetY = e1.field_70163_u;
            double targetZ = e1.func_174813_aQ().field_72339_c + length1 / 2.0;
            double difXt = targetX - e2.field_70165_t;
            double difY = targetY - e2.field_70163_u;
            double difZ = targetZ - e2.field_70161_v;
            double length = Math.sqrt(difXt * difXt + difY * difY + difZ * difZ);
            double difX = difXt / (length * density);
            difY /= length * density;
            double veldif = difX / difXt;
            double velcur = 1.0;
            double randX = difX * world.field_73012_v.nextDouble();
            double randZ = (difZ /= length * density) * world.field_73012_v.nextDouble();
            while (Math.signum(difX) == 1.0 ? currentX < targetX : currentX > targetX) {
                double motionX = e2.field_70159_w * velcur;
                double motionY = e2.field_70181_x * velcur;
                double motionZ = e2.field_70179_y * velcur;
                if (e1.field_70170_p.field_72995_K) {
                    e1.field_70170_p.func_175688_a(type, currentX + randX, currentY, currentZ + randZ, motionX, motionY, motionZ, parameters);
                } else if (e1.field_70170_p instanceof WorldServer) {
                    WorldServer worldServer = (WorldServer)e1.field_70170_p;
                    worldServer.func_175739_a(type, currentX + randX, currentY, currentZ + randZ, 1, motionX, motionY, motionZ, world.field_73012_v.nextBoolean() ? 0.01 : -0.01, parameters);
                }
                currentX += difX;
                currentY += difY;
                currentZ += difZ;
                velcur -= veldif;
            }
        }
    }

    public static String getSkin(EntityPlayer player) {
        String skinType = DefaultPlayerSkin.func_177332_b((UUID)player.func_110124_au());
        if (player instanceof AbstractClientPlayer) {
            skinType = ((AbstractClientPlayer)player).func_175154_l();
        }
        return skinType;
    }

    public static IBlockState getBlockBelow(Entity entity) {
        return EntityUtil.getBlockBelow(entity.field_70170_p, entity.func_180425_c());
    }

    public static IBlockState getBlockBelow(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        while (state == Blocks.field_150350_a.func_176223_P() && pos.func_177956_o() > 0 && pos.func_177956_o() < 256) {
            pos = pos.func_177977_b();
            state = world.func_180495_p(pos);
        }
        return state;
    }

    public static void spawnEffectParticles(EntityLivingBase entity, IAetherStatusEffects.effectTypes effect) {
        IAetherStatusEffectPool statusEffectPool = (IAetherStatusEffectPool)entity.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
        if (!entity.field_70170_p.field_72995_K && statusEffectPool != null && effect != null) {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            r = (float)EffectSystemOverlay.Color.getColorFromEffect((IAetherStatusEffects.effectTypes)effect).r / 255.0f;
            g = (float)EffectSystemOverlay.Color.getColorFromEffect((IAetherStatusEffects.effectTypes)effect).g / 255.0f;
            b = (float)EffectSystemOverlay.Color.getColorFromEffect((IAetherStatusEffects.effectTypes)effect).b / 255.0f;
            double x = entity.field_70165_t;
            double y = (entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b) / 2.0 + entity.func_174813_aQ().field_72338_b;
            double z = entity.field_70161_v;
            for (int i = 0; i < 2; ++i) {
                double radius = 0.4;
                double randX = entity.func_70681_au().nextDouble() * (entity.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.4;
                double randY = entity.func_70681_au().nextDouble() * (entity.func_70681_au().nextBoolean() ? 1.0 : -1.0) * (entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b);
                double randZ = entity.func_70681_au().nextDouble() * (entity.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.4;
                double randMotionY = entity.func_70681_au().nextInt(5);
                NetworkingAether.sendPacketToDimension(new PacketStatusParticles(x + randX, y + randY, z + randZ, 0.0, randMotionY == 0.0 ? 0.1 : randMotionY / 50.0, 0.0, r, g, b), entity.field_71093_bK);
            }
        }
    }
}

