/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.util.helpers;

import com.gildedgames.aether.common.ConfigAether;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.init.InstancesAether;
import com.gildedgames.aether.common.world.instances.necromancer_tower.NecromancerTowerInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class AetherHelper {
    public static boolean isEnabled(World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.func_186058_p() == DimensionsAether.AETHER || world.field_73011_w.func_186058_p() == DimensionsAether.NECROMANCER_TOWER;
    }

    public static boolean isEnabled(int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world != null) {
            return AetherHelper.isEnabled((World)world);
        }
        return AetherHelper.isNecromancerTower(dimension) || AetherHelper.isAether(dimension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNecromancerTower(int dimension) {
        NecromancerTowerInstance instance = InstancesAether.NECROMANCER_TOWER_HANDLER.getFromDimId(dimension);
        if (instance != null) return true;
        if (dimension != ConfigAether.necromancerDimId) return false;
        return true;
    }

    public static boolean isAether(int dimension) {
        return dimension == ConfigAether.aetherDimID;
    }

    public static boolean isAether(World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.func_186058_p() == DimensionsAether.AETHER;
    }

    public static boolean isNecromancerTower(World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.func_186058_p() == DimensionsAether.NECROMANCER_TOWER;
    }
}

