/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.util;

import com.gildedgames.aether.common.AetherCore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarValidator {
    private static final String MANIFEST_PATH = "/META-INF/MANIFEST.MF";

    public static boolean validate(File file) {
        Manifest prop;
        try (JarInputStream stream = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));){
            prop = stream.getManifest();
        }
        catch (IOException e) {
            AetherCore.LOGGER.warn("Couldn't open and decode JAR manifest information", (Throwable)e);
            return true;
        }
        String expectedFileName = prop.getMainAttributes().getValue("SignedFileName");
        if (expectedFileName == null) {
            AetherCore.LOGGER.warn("JAR manifest does not contain attributes for extended validation");
            return true;
        }
        return file.getName().equals(expectedFileName);
    }
}

