/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.travellers_guidebook.entries;

import com.gildedgames.aether.api.cache.IEntityStats;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.api.player.conditions.IConditionResolution;
import com.gildedgames.aether.api.player.conditions.IPlayerCondition;
import com.gildedgames.aether.api.travellers_guidebook.entries.ITGEntryBestiaryPage;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConditionModule;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionFeedEntity;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionKillEntity;
import com.gildedgames.aether.common.travellers_guidebook.TGEntryBase;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class TGEntryBestiaryPage
extends TGEntryBase
implements ITGEntryBestiaryPage {
    private final ResourceLocation entityId;
    private final String tag;
    private final ResourceLocation silhouetteTexture;
    private final ResourceLocation discoveredTexture;
    private final ResourceLocation silhouetteSlotTexture;
    private final ResourceLocation discoveredSlotTexture;
    private final String unlocalizedDescription;

    protected TGEntryBestiaryPage(String tag, ResourceLocation entityId, String unlocalizedDescription, ResourceLocation silhouetteTexture, ResourceLocation discoveredTexture, ResourceLocation silhouetteSlotTexture, ResourceLocation discoveredSlotTexture) {
        this.tag = tag;
        this.entityId = entityId;
        this.unlocalizedDescription = unlocalizedDescription;
        this.silhouetteTexture = silhouetteTexture;
        this.discoveredTexture = discoveredTexture;
        this.silhouetteSlotTexture = silhouetteSlotTexture;
        this.discoveredSlotTexture = discoveredSlotTexture;
    }

    @Override
    public Collection<IPlayerCondition> providePlayerConditions() {
        ArrayList conditions = Lists.newArrayList();
        conditions.add(new PlayerConditionFeedEntity(this.entityId));
        conditions.add(new PlayerConditionKillEntity(this.entityId));
        return conditions;
    }

    @Override
    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    @Override
    public ResourceLocation getSilhouetteTexture() {
        return this.silhouetteTexture;
    }

    @Override
    public ResourceLocation getDiscoveredTexture() {
        return this.discoveredTexture;
    }

    @Override
    public ResourceLocation getDiscoveredSlotTexture() {
        return this.discoveredSlotTexture;
    }

    @Override
    public ResourceLocation getSilhouetteSlotTexture() {
        return this.silhouetteSlotTexture;
    }

    @Override
    public IEntityStats getEntityStats() {
        return AetherCore.PROXY.content().entityStatsCache().getStats(this.entityId);
    }

    @Override
    public String getUnlocalizedDescription() {
        return this.unlocalizedDescription;
    }

    @Override
    public String getEntityName() {
        return I18n.func_135052_a((String)("entity." + this.getEntityId().func_110624_b() + "." + this.getEntityId().func_110623_a() + ".name"), (Object[])new Object[0]);
    }

    @Override
    public boolean isUnderstood(IPlayerAether playerAether) {
        return playerAether.getModule(PlayerConditionModule.class).areConditionsFlagged(IConditionResolution.REQUIRE_ANY, AetherCore.getResource("feedEntity:" + this.entityId), AetherCore.getResource("killEntity:" + this.entityId));
    }

    @Override
    public boolean hasUnlockedCompleteOverview(IPlayerAether playerAether) {
        return this.isUnderstood(playerAether);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public static class Deserializer
    implements JsonDeserializer<TGEntryBestiaryPage> {
        public TGEntryBestiaryPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            return new TGEntryBestiaryPage(obj.get("tag").getAsString(), new ResourceLocation(obj.get("entityId").getAsString()), obj.get("description").getAsString(), new ResourceLocation(obj.get("silhouetteTexture").getAsString()), new ResourceLocation(obj.get("discoveredTexture").getAsString()), new ResourceLocation(obj.get("silhouetteSlotTexture").getAsString()), new ResourceLocation(obj.get("discoveredSlotTexture").getAsString()));
        }
    }
}

