/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.travellers_guidebook;

import com.gildedgames.aether.api.player.conditions.ConditionResolutionDeserializer;
import com.gildedgames.aether.api.player.conditions.IConditionResolution;
import com.gildedgames.aether.api.player.conditions.IPlayerCondition;
import com.gildedgames.aether.api.player.conditions.IPlayerConditionTracker;
import com.gildedgames.aether.api.player.conditions.PlayerConditionUtils;
import com.gildedgames.aether.api.player.conditions.resolutions.ConditionResolutionRequireAll;
import com.gildedgames.aether.api.player.conditions.resolutions.ConditionResolutionRequireAny;
import com.gildedgames.aether.api.travellers_guidebook.ITGDefinition;
import com.gildedgames.aether.api.travellers_guidebook.ITGEntry;
import com.gildedgames.aether.api.travellers_guidebook.ITGManager;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.player_conditions.PlayerConditionDeserializer;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionFeedEntity;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionKillEntity;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionSeeEntity;
import com.gildedgames.aether.common.travellers_guidebook.TGDefinition;
import com.gildedgames.aether.common.travellers_guidebook.TGEntryDeserializer;
import com.gildedgames.aether.common.travellers_guidebook.entries.TGEntryBestiaryPage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TGManager
implements ITGManager {
    private final Gson gson;
    private final Map<String, List<ITGEntry>> tagToEntries = Maps.newHashMap();
    private final Map<String, ITGEntry> idToEntries = Maps.newHashMap();
    private final List<ResourceLocation> definitionsToLoad = Lists.newArrayList();
    private final IPlayerConditionTracker playerConditionTracker;

    public TGManager(IPlayerConditionTracker playerConditionTracker) {
        this.gson = this.buildDeserializer().create();
        this.playerConditionTracker = playerConditionTracker;
    }

    private GsonBuilder buildDeserializer() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(IPlayerCondition.class, (Object)new PlayerConditionDeserializer());
        builder.registerTypeAdapter(IConditionResolution.class, (Object)new ConditionResolutionDeserializer());
        builder.registerTypeAdapter(ITGEntry.class, (Object)new TGEntryDeserializer());
        builder.registerTypeAdapter(PlayerConditionSeeEntity.class, (Object)new PlayerConditionSeeEntity.Deserializer());
        builder.registerTypeAdapter(PlayerConditionFeedEntity.class, (Object)new PlayerConditionFeedEntity.Deserializer());
        builder.registerTypeAdapter(PlayerConditionKillEntity.class, (Object)new PlayerConditionKillEntity.Deserializer());
        builder.registerTypeAdapter(ConditionResolutionRequireAll.class, (Object)new ConditionResolutionRequireAll.Deserializer());
        builder.registerTypeAdapter(ConditionResolutionRequireAny.class, (Object)new ConditionResolutionRequireAny.Deserializer());
        builder.registerTypeAdapter(TGEntryBestiaryPage.class, (Object)new TGEntryBestiaryPage.Deserializer());
        return builder;
    }

    @Override
    public void registerEntry(ResourceLocation entry) {
        this.definitionsToLoad.add(entry);
    }

    @Override
    public void load() {
        for (ResourceLocation location : this.definitionsToLoad) {
            this.loadDefinitions(location);
        }
    }

    private void loadDefinitions(ResourceLocation location) {
        try {
            String path = location.func_110623_a();
            String definitionPath = "/assets/" + location.func_110624_b() + "/travellers_guidebook/definitions/" + path + ".json";
            AetherCore.LOGGER.info("Loading definitions from file {}", (Object)definitionPath);
            try (InputStream stream = MinecraftServer.class.getResourceAsStream(definitionPath);
                 InputStreamReader reader = new InputStreamReader(stream);){
                TGDefinition[] definitions;
                for (TGDefinition def : definitions = (TGDefinition[])this.gson.fromJson((Reader)reader, TGDefinition[].class)) {
                    this.registerDefinition(def);
                }
            }
        }
        catch (IOException e) {
            AetherCore.LOGGER.error("Failed to load definitions: {}", (Object)location, (Object)e);
        }
    }

    private void registerDefinition(ITGDefinition def) {
        Collection<ResourceLocation> conditionIDs = PlayerConditionUtils.getIDs(def.conditions());
        this.playerConditionTracker.trackConditions(def.conditions());
        for (Map.Entry<String, ITGEntry> e : def.entries().entrySet()) {
            ITGEntry entryDef = e.getValue();
            String entryId = e.getKey();
            if (this.idToEntries.containsKey(entryId)) {
                throw new RuntimeException("An entry with an existing id is trying to be registered: " + entryId);
            }
            entryDef.setConditionResolution(def.resolution());
            this.playerConditionTracker.trackConditions(entryDef.providePlayerConditions());
            entryDef.setConditionIDs(conditionIDs);
            this.idToEntries.put(entryId, entryDef);
            String tag = entryDef.getTag();
            if (tag == null || tag.isEmpty()) continue;
            if (!this.tagToEntries.containsKey(tag)) {
                this.tagToEntries.put(tag, Lists.newArrayList());
            }
            List<ITGEntry> tagList = this.tagToEntries.get(tag);
            tagList.add(entryDef);
        }
    }

    @Override
    public void unload() {
        this.tagToEntries.clear();
        this.idToEntries.clear();
        this.playerConditionTracker.unload();
    }

    @Override
    public List<ITGEntry> getEntriesWithTag(String tag) {
        if (this.tagToEntries.containsKey(tag)) {
            return this.tagToEntries.get(tag);
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends ITGEntry> List<T> getEntriesWithTagAndClass(String tag, Class<T> clazzType) {
        if (this.tagToEntries.containsKey(tag)) {
            ArrayList entries = Lists.newArrayList();
            for (ITGEntry entry : this.tagToEntries.get(tag)) {
                if (!entry.getClass().isAssignableFrom(clazzType)) continue;
                entries.add(entry);
            }
            return entries;
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends ITGEntry> Optional<T> getEntry(String entryId, Class<T> clazzType) {
        if (this.idToEntries.containsKey(entryId)) {
            return Optional.of(this.idToEntries.get(entryId));
        }
        return Optional.empty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void attachReloadListener() {
        Object[] stackTraceElements = Thread.currentThread().getStackTrace();
        System.out.println(Arrays.toString(stackTraceElements));
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        if (resManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resManager).func_110542_a((IResourceManagerReloadListener)new ReloadListener(this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ReloadListener
    implements IResourceManagerReloadListener {
        private final TGManager manager;

        public ReloadListener(TGManager manager) {
            this.manager = manager;
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.manager.unload();
            this.manager.load();
        }
    }
}

