/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.shop;

import com.gildedgames.aether.api.shop.IShopBuyDefinition;
import com.gildedgames.aether.api.shop.IShopDefinition;
import com.gildedgames.aether.common.AetherCore;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ShopSchema
implements IShopDefinition {
    @SerializedName(value="buy_definitions")
    private final List<ShopBuyDefinitionSchema> buyDefinitions = null;
    @SerializedName(value="greetings")
    private final Collection<String> greetings = null;
    @SerializedName(value="max_stock")
    private int maxStock;
    @SerializedName(value="min_stock")
    private int minStock;
    @SerializedName(value="currency_type")
    private String currencyType = null;

    @Override
    public List<IShopBuyDefinition> getBuyDefinitions() {
        return this.buyDefinitions == null ? Collections.emptyList() : Collections.unmodifiableList(this.buyDefinitions);
    }

    @Override
    public Collection<String> getUnlocalizedGreetings() {
        return this.greetings == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.greetings);
    }

    @Override
    public int getMaxStock() {
        return this.maxStock;
    }

    @Override
    public int getMinStock() {
        return this.minStock;
    }

    @Override
    public String getCurrencyType() {
        return this.currencyType == null ? "" : this.currencyType;
    }

    private class ShopBuyDefinitionSchema
    implements IShopBuyDefinition {
        @SerializedName(value="ticks_until_restock")
        public int ticksUntilRestock;
        @SerializedName(value="rarity_weight")
        public float rarityWeight;
        @SerializedName(value="min_price")
        public int min_price;
        @SerializedName(value="max_price")
        public int max_price;
        @SerializedName(value="min_stock")
        public int min_stock;
        @SerializedName(value="max_stock")
        public int max_stock;
        @SerializedName(value="min_sell_price")
        public double min_sell_price;
        @SerializedName(value="max_sell_price")
        public double max_sell_price;
        @SerializedName(value="stack")
        private ItemStackSchema stack = null;
        @SerializedName(value="descriptions")
        private Collection<String> descriptions = null;

        private ShopBuyDefinitionSchema() {
        }

        @Override
        public Optional<ItemStack> getItemStack() {
            if (this.stack == null) {
                return Optional.empty();
            }
            return this.stack.getStack() == null ? Optional.empty() : Optional.of(this.stack.getStack());
        }

        @Override
        public Collection<String> getUnlocalizedDescriptions() {
            return this.descriptions == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.descriptions);
        }

        @Override
        public int getTicksUntilRestock() {
            return this.ticksUntilRestock;
        }

        @Override
        public float getRarityWeight() {
            return this.rarityWeight;
        }

        @Override
        public double getMinSellPrice() {
            return this.min_sell_price;
        }

        @Override
        public double getMaxSellPrice() {
            return this.max_sell_price;
        }

        @Override
        public int getMinPrice() {
            return this.min_price;
        }

        @Override
        public int getMaxPrice() {
            return this.max_price;
        }

        @Override
        public int getMaxStock() {
            return this.max_stock;
        }

        @Override
        public int getMinStock() {
            return this.min_stock;
        }
    }

    private class ItemStackSchema {
        private transient ItemStack stack;
        @SerializedName(value="item")
        private String item = null;
        @SerializedName(value="data")
        private int data;

        private ItemStackSchema() {
        }

        public ItemStack getStack() {
            if (this.stack == null && this.item != null) {
                ResourceLocation resource = new ResourceLocation(this.item);
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resource);
                Item item = block != Blocks.field_150350_a ? Item.func_150898_a((Block)block) : (Item)Item.field_150901_e.func_82594_a((Object)resource);
                if (item != null) {
                    this.stack = new ItemStack(item, 1, this.data);
                } else {
                    AetherCore.LOGGER.error("Failed to load Item: {}", (Object)this.item);
                }
            }
            return this.stack;
        }
    }
}

