/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.shop;

import com.gildedgames.aether.api.shop.IShopBuyDefinition;
import com.gildedgames.aether.api.shop.IShopCurrency;
import com.gildedgames.aether.api.shop.IShopDefinition;
import com.gildedgames.aether.api.shop.IShopFilter;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopManager;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.shop.ShopBuy;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import com.gildedgames.aether.common.shop.ShopCurrencyPlumproot;
import com.gildedgames.aether.common.shop.ShopInstance;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ShopManager
implements IShopManager {
    private final HashMap<ResourceLocation, IShopDefinition> cachedDefinitions = new HashMap();
    private final Gson gson;
    private final boolean allowCaching;
    private final List<IShopFilter> globalFilters = Lists.newArrayList();

    public ShopManager() {
        this(true);
    }

    public ShopManager(boolean allowCaching) {
        this.allowCaching = allowCaching;
        this.gson = this.buildDeserializer().create();
    }

    protected GsonBuilder buildDeserializer() {
        return new GsonBuilder();
    }

    @Override
    public Optional<IShopDefinition> getShopDefinition(ResourceLocation resource) {
        IShopDefinition speaker;
        if (this.allowCaching && this.cachedDefinitions.containsKey(resource)) {
            return Optional.of(this.cachedDefinitions.get(resource));
        }
        try {
            speaker = this.loadShopDefinition(resource);
            if (this.allowCaching) {
                this.cachedDefinitions.put(resource, speaker);
            }
        }
        catch (IOException e) {
            AetherCore.LOGGER.error("Failed to load shop definition: {}", (Object)resource, (Object)e);
            return Optional.empty();
        }
        return Optional.of(speaker);
    }

    @Override
    public IShopInstance createInstance(ResourceLocation definitionLocation, IShopDefinition definition, Random rand) {
        int stock = MathHelper.func_76136_a((Random)rand, (int)definition.getMinStock(), (int)definition.getMaxStock());
        if (stock > definition.getBuyDefinitions().size()) {
            throw new IllegalArgumentException("One of your shop definitions has a higher stock possibility than the amount of stock options");
        }
        ArrayList chosenStockDefs = Lists.newArrayList();
        IShopBuyDefinition it = null;
        for (int i = 0; i < stock; ++i) {
            while (it == null || chosenStockDefs.contains(it)) {
                it = definition.getBuyDefinitions().get(rand.nextInt(definition.getBuyDefinitions().size()));
            }
            chosenStockDefs.add(it);
        }
        LinkedList chosenStock = Lists.newLinkedList();
        for (IShopBuyDefinition def : chosenStockDefs) {
            if (!def.getItemStack().isPresent()) continue;
            int price = MathHelper.func_76136_a((Random)rand, (int)def.getMinPrice(), (int)def.getMaxPrice());
            double sellingPrice = MathUtil.getDoubleRange(rand, def.getMinSellPrice(), def.getMaxSellPrice());
            int maxStock = MathHelper.func_76136_a((Random)rand, (int)def.getMinStock(), (int)def.getMaxStock());
            int ticksUntilRestock = def.getTicksUntilRestock();
            ItemStack stack = def.getItemStack().get().func_77946_l();
            chosenStock.add(new ShopBuy(stack, Lists.newArrayList(def.getUnlocalizedDescriptions()), price, sellingPrice, ticksUntilRestock, maxStock));
        }
        IShopCurrency currency = new ShopCurrencyGilt();
        switch (definition.getCurrencyType()) {
            case "plumproots": {
                currency = new ShopCurrencyPlumproot();
            }
        }
        return new ShopInstance(definitionLocation, chosenStock, Lists.newArrayList(definition.getUnlocalizedGreetings()), currency);
    }

    @Override
    public List<IShopFilter> getGlobalFilters() {
        return this.globalFilters;
    }

    @Override
    public void registerGlobalFilter(IShopFilter filter) {
        if (!this.globalFilters.contains(filter)) {
            this.globalFilters.add(filter);
        }
    }

    /*
     * Exception decompiling
     */
    private IShopDefinition loadShopDefinition(ResourceLocation resource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

