/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.shop;

import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.aether.api.shop.IShopCurrency;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import com.gildedgames.aether.common.shop.ShopInventory;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ShopInstance
implements IShopInstance {
    private LinkedList<IShopBuy> stock;
    private List<String> greetings;
    private boolean isDirty;
    private Map<UUID, ShopInventory> inventories = Maps.newHashMap();
    private IShopCurrency currencyType;
    private ResourceLocation shopDefinitionLocation;

    private ShopInstance() {
    }

    public ShopInstance(ResourceLocation shopDefinitionLocation, LinkedList<IShopBuy> stock, List<String> greetings, IShopCurrency currencyType) {
        this.shopDefinitionLocation = shopDefinitionLocation;
        this.stock = stock;
        this.greetings = greetings;
        this.currencyType = currencyType;
    }

    @Override
    public ResourceLocation getShopDefinitionLocation() {
        return this.shopDefinitionLocation;
    }

    @Override
    public List<IShopBuy> getStock() {
        return this.stock;
    }

    @Override
    public List<String> getUnlocalizedGreetings() {
        return this.greetings;
    }

    @Override
    public void tick() {
        for (IShopBuy buy : this.stock) {
            buy.tick();
            if (!buy.isDirty()) continue;
            this.isDirty = true;
        }
    }

    @Override
    public IInventory getInventory(EntityPlayer player) {
        if (!this.inventories.containsKey(player.func_110124_au())) {
            this.inventories.put(player.func_110124_au(), new ShopInventory(this));
        }
        return this.inventories.get(player.func_110124_au());
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void markClean() {
        this.isDirty = false;
        for (IShopBuy buy : this.stock) {
            buy.markClean();
        }
    }

    @Override
    public IShopCurrency getCurrencyType() {
        return this.currencyType;
    }

    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setList("stock", this.stock);
        funnel.setStringList("greetings", this.greetings);
        funnel.setMap("inventories", this.inventories, NBTFunnel.UUID_SETTER, NBTFunnel.setter());
        funnel.set("currencyType", (NBT)this.currencyType);
        if (this.shopDefinitionLocation != null) {
            tag.func_74778_a("shopDefinitionLocation", this.shopDefinitionLocation.toString());
        }
    }

    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.stock = Lists.newLinkedList((Iterable)funnel.getList("stock"));
        this.greetings = funnel.getStringList("greetings");
        this.inventories = funnel.getMap("inventories", NBTFunnel.UUID_GETTER, NBTFunnel.getter());
        for (ShopInventory inventory : this.inventories.values()) {
            inventory.setShopInstance(this);
        }
        this.currencyType = (IShopCurrency)funnel.getWithDefault("currencyType", ShopCurrencyGilt::new);
        if (tag.func_74764_b("shopDefinitionLocation")) {
            this.shopDefinitionLocation = new ResourceLocation(tag.func_74779_i("shopDefinitionLocation"));
        }
    }
}

