/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.shop;

import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.shop.ICurrencyListener;
import com.gildedgames.aether.api.shop.IGuiCurrencyValue;
import com.gildedgames.aether.api.shop.IShopCurrency;
import com.gildedgames.aether.client.gui.dialog.GuiPumpkinCurrency;
import com.gildedgames.aether.common.blocks.natural.plants.BlockPlumproot;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ShopCurrencyPlumproot
implements IShopCurrency {
    private final List<ICurrencyListener> listeners = Lists.newArrayList();
    private long value;

    @Override
    public long getValue(IPlayerAether playerAether) {
        this.update(playerAether);
        return this.value;
    }

    @Override
    public void addValue(long value, IPlayerAether playerAether) {
        long old = this.value;
        for (long i = value; i > 0L; i -= 64L) {
            playerAether.getEntity().func_191521_c(new ItemStack(BlocksAether.plumproot, (int)Math.min(64L, i)));
        }
        this.value += value;
        this.listeners.forEach(l -> l.onCurrencyChange(old, value));
    }

    @Override
    public void removeValue(long value, IPlayerAether playerAether) {
        EntityPlayer player = playerAether.getEntity();
        long count = value;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemBlock block;
            if (count <= 0L) {
                return;
            }
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!(stack.func_77973_b() instanceof ItemBlock) || !((block = (ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockPlumproot)) continue;
            long reduce = Math.min(64L, count);
            player.field_71071_by.func_70298_a(i, (int)reduce);
            count -= reduce;
        }
        long old = this.value;
        this.value -= value;
        this.listeners.forEach(l -> l.onCurrencyChange(old, value));
    }

    @Override
    public IGuiCurrencyValue createCurrencyValueGui(Rect rect) {
        return new GuiPumpkinCurrency(rect);
    }

    @Override
    public IGuiCurrencyValue createBuyItemCurrencyValueGui(Rect rect) {
        return new GuiPumpkinCurrency(rect);
    }

    @Override
    public IGuiCurrencyValue createSellItemCurrencyValueGui(Rect rect) {
        return new GuiPumpkinCurrency(rect);
    }

    @Override
    public void listenForCurrency(IPlayerAether playerAether, ICurrencyListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean unlistenForCurrency(IPlayerAether playerAether, ICurrencyListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void update(IPlayerAether playerAether) {
        EntityPlayer player = playerAether.getEntity();
        long count = 0L;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemBlock block;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!(stack.func_77973_b() instanceof ItemBlock) || !((block = (ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockPlumproot)) continue;
            count += (long)stack.func_190916_E();
        }
        if (count != this.value) {
            long finalCount = count;
            long old = this.value;
            this.value = count;
            this.listeners.forEach(l -> l.onCurrencyChange(old, finalCount));
        }
    }

    public void write(NBTTagCompound tag) {
    }

    public void read(NBTTagCompound tag) {
    }
}

