/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.shop;

import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ShopBuy
implements IShopBuy {
    private ItemStack stack;
    private int price;
    private double sellingPrice;
    private int ticksUntilRestock;
    private int maxStock;
    private int currentTicks;
    private List<String> descriptions;
    private boolean isDirty;
    private int stock;

    private ShopBuy() {
    }

    public ShopBuy(ItemStack stack, List<String> descriptions, int price, double sellingPrice, int ticksUntilRestock, int maxStock) {
        this.stack = stack;
        this.descriptions = descriptions;
        this.price = price;
        this.sellingPrice = sellingPrice;
        this.ticksUntilRestock = ticksUntilRestock;
        this.maxStock = maxStock;
        this.stock = maxStock;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void addStock(int stock) {
        this.stock = Math.max(0, this.stock + stock);
        this.isDirty = true;
    }

    @Override
    public int getStock() {
        return this.stock;
    }

    @Override
    public List<String> getUnlocalizedDescriptions() {
        return this.descriptions;
    }

    @Override
    public int getMaxStock() {
        return this.maxStock;
    }

    @Override
    public int getTicksUntilRestock() {
        return this.ticksUntilRestock;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public double getSellingPrice() {
        return this.sellingPrice;
    }

    @Override
    public void tick() {
        if (this.getStock() < this.getMaxStock()) {
            ++this.currentTicks;
            if (this.currentTicks >= this.getTicksUntilRestock()) {
                this.currentTicks = 0;
                this.addStock(1);
            }
        } else {
            this.currentTicks = 0;
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void markClean() {
        this.isDirty = false;
    }

    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setStack("stack", this.stack);
        funnel.setStringList("descriptions", this.descriptions);
        tag.func_74768_a("price", this.price);
        tag.func_74780_a("sellingPrice", this.sellingPrice);
        tag.func_74768_a("maxStock", this.maxStock);
        tag.func_74768_a("ticksUntilRestock", this.ticksUntilRestock);
        tag.func_74768_a("stock", this.stock);
    }

    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.stack = funnel.getStack("stack");
        this.descriptions = funnel.getStringList("descriptions");
        this.price = tag.func_74762_e("price");
        this.sellingPrice = tag.func_74769_h("sellingPrice");
        this.maxStock = tag.func_74762_e("maxStock");
        this.ticksUntilRestock = tag.func_74762_e("ticksUntilRestock");
        this.stock = tag.func_74762_e("stock");
    }
}

