/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.recipes.simple;

import com.gildedgames.aether.api.recipes.simple.ISimpleCraftingRegistry;
import com.gildedgames.aether.api.recipes.simple.ISimpleRecipe;
import com.gildedgames.aether.api.recipes.simple.ISimpleRecipeGroup;
import com.gildedgames.aether.common.recipes.simple.OreDictionaryRequirement;
import com.gildedgames.aether.common.recipes.simple.SimpleRecipeGroup;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleCraftingRegistry
implements ISimpleCraftingRegistry {
    private final HashBiMap<Integer, ISimpleRecipe> recipes = HashBiMap.create();
    private final Map<Integer, ISimpleRecipeGroup> stackLookup = Maps.newHashMap();
    private final Map<String, ISimpleRecipeGroup> oreDictionaryLookup = Maps.newHashMap();
    private int id;

    @Override
    public Collection<ISimpleRecipe> getAllRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public void registerRecipe(ISimpleRecipe recipe) {
        this.recipes.put((Object)this.id, (Object)recipe);
        ++this.id;
    }

    public void finalizeRecipes() {
        this.stackLookup.clear();
        this.oreDictionaryLookup.clear();
        for (ISimpleRecipe recipe : this.recipes.values()) {
            for (Object req : recipe.getRequired()) {
                ISimpleRecipeGroup group;
                if (req instanceof ItemStack) {
                    if (((ItemStack)req).func_190926_b()) continue;
                    int hash = this.getItemStackKey((ItemStack)req);
                    if (!this.stackLookup.containsKey(hash)) {
                        group = new SimpleRecipeGroup();
                        group.addRecipe(recipe);
                        this.stackLookup.put(hash, group);
                        continue;
                    }
                    group = this.stackLookup.get(hash);
                    if (group.getRecipes().contains(recipe)) continue;
                    group.addRecipe(recipe);
                    continue;
                }
                if (!(req instanceof OreDictionaryRequirement)) continue;
                OreDictionaryRequirement oreReq = (OreDictionaryRequirement)req;
                if (!this.oreDictionaryLookup.containsKey(oreReq.getKey())) {
                    group = new SimpleRecipeGroup();
                    group.addRecipe(recipe);
                    this.oreDictionaryLookup.put(oreReq.getKey(), group);
                    continue;
                }
                group = this.oreDictionaryLookup.get(oreReq.getKey());
                if (group.getRecipes().contains(recipe)) continue;
                group.addRecipe(recipe);
            }
        }
    }

    @Override
    public ISimpleRecipe getRecipeFromID(int id) {
        if (id < 0) {
            return null;
        }
        return (ISimpleRecipe)this.recipes.get((Object)id);
    }

    @Override
    public int getIDFromRecipe(ISimpleRecipe recipe) {
        if (recipe == null) {
            return -1;
        }
        return (Integer)this.recipes.inverse().get((Object)recipe);
    }

    @Override
    public Collection<ISimpleRecipeGroup> getRecipesFromRequirement(Object req) {
        if (req instanceof ItemStack) {
            ItemStack stack = (ItemStack)req;
            if (stack.func_190926_b()) {
                return new ArrayList<ISimpleRecipeGroup>();
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            if (ids.length > 0) {
                ArrayList groups = Lists.newArrayList();
                for (int id : ids) {
                    String key = OreDictionary.getOreName((int)id);
                    if (!this.oreDictionaryLookup.containsKey(key)) continue;
                    groups.add(this.oreDictionaryLookup.get(key));
                }
                if (groups.size() > 0) {
                    int key = this.getItemStackKey(stack);
                    return Lists.newArrayList((Object[])new ISimpleRecipeGroup[]{this.stackLookup.get(key)});
                }
            }
            int hash = this.getItemStackKey(stack);
            return Lists.newArrayList((Object[])new ISimpleRecipeGroup[]{this.stackLookup.get(hash)});
        }
        if (req instanceof OreDictionaryRequirement) {
            return Lists.newArrayList((Object[])new ISimpleRecipeGroup[]{this.oreDictionaryLookup.get(((OreDictionaryRequirement)req).getKey())});
        }
        if (req instanceof String) {
            return Lists.newArrayList((Object[])new ISimpleRecipeGroup[]{this.oreDictionaryLookup.get(req)});
        }
        return new ArrayList<ISimpleRecipeGroup>();
    }

    private int getItemStackKey(ItemStack stack) {
        int hash = (Item.func_150891_b((Item)stack.func_77973_b()) & 0xFFFF) << 16;
        if (!stack.func_77984_f() && stack.func_77952_i() != Short.MAX_VALUE) {
            hash |= stack.func_77952_i() & 0xFFFF;
        }
        return hash;
    }
}

