/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.recipes;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MasonryRecipes {
    private static final MasonryRecipes MASONRY_BASE = new MasonryRecipes();
    private final Map<ItemStack, ItemStack[]> masonryList = Maps.newHashMap();

    public static MasonryRecipes instance() {
        return MASONRY_BASE;
    }

    public void addMasonry(Block input, ItemStack ... stack) {
        this.addMasonryRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addMasonryItem(Item input, ItemStack ... stack) {
        this.addMasonryRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addMasonryRecipe(ItemStack input, ItemStack ... stack) {
        this.masonryList.put(input, stack);
    }

    public ItemStack[] getOutput(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.masonryList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<ItemStack, ItemStack[]> getMasonryList() {
        return this.masonryList;
    }

    private boolean compareItemStacks(ItemStack stack, ItemStack toCompare) {
        return toCompare.func_77973_b() == stack.func_77973_b() && (toCompare.func_77960_j() == Short.MAX_VALUE || toCompare.func_77960_j() == stack.func_77960_j());
    }
}

