/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.recipes;

import com.gildedgames.aether.common.AetherCore;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CoolerRecipes {
    private static final CoolerRecipes COOLING_BASE = new CoolerRecipes();
    private final Map<Map<ItemStack, ItemStack>, ItemStack[]> coolingList = Maps.newHashMap();
    private final Map<Map<ItemStack, ItemStack>, ItemStack> outputList = Maps.newHashMap();
    private final Random rand = new Random();

    public static CoolerRecipes instance() {
        return COOLING_BASE;
    }

    public void addCoolingFromItem(Item input, Item inputSecondary, ItemStack outputSecondary, ItemStack ... stackList) {
        HashMap map = Maps.newHashMap();
        map.put(new ItemStack(input, 1, Short.MAX_VALUE), new ItemStack(inputSecondary, 1, Short.MAX_VALUE));
        this.addCoolingRecipe(map, outputSecondary, stackList);
    }

    public void addCoolingRecipe(Map<ItemStack, ItemStack> inputMap, ItemStack outputSecondary, ItemStack ... stackList) {
        for (Map.Entry<ItemStack, ItemStack> entry : inputMap.entrySet()) {
            if (this.getCoolingResult(entry.getKey(), entry.getValue()) == ItemStack.field_190927_a) continue;
            AetherCore.LOGGER.warn("Ignored cooling recipe with conflicting input: " + inputMap + stackList[0]);
            return;
        }
        this.outputList.put(inputMap, outputSecondary);
        this.coolingList.put(inputMap, stackList);
    }

    public ItemStack getPrimaryOutput(ItemStack stack) {
        for (Map.Entry<Map<ItemStack, ItemStack>, ItemStack[]> entry : this.coolingList.entrySet()) {
            for (Map.Entry<ItemStack, ItemStack> entryInput : entry.getKey().entrySet()) {
                if (!this.compareItemStacks(stack, entryInput.getKey())) continue;
                return entry.getValue()[this.rand.nextInt(entry.getValue().length)];
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getSecondaryOutput(ItemStack stack) {
        for (Map.Entry<Map<ItemStack, ItemStack>, ItemStack> entry : this.outputList.entrySet()) {
            for (Map.Entry<ItemStack, ItemStack> entryInput : entry.getKey().entrySet()) {
                if (!this.compareItemStacks(stack, entryInput.getKey())) continue;
                return entry.getValue();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getSecondaryInputForSlot(ItemStack stack) {
        for (Map.Entry<Map<ItemStack, ItemStack>, ItemStack[]> entry : this.coolingList.entrySet()) {
            for (Map.Entry<ItemStack, ItemStack> entryInput : entry.getKey().entrySet()) {
                if (!this.compareItemStacks(stack, entryInput.getValue())) continue;
                return entryInput.getValue();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getSecondaryInput(ItemStack stack) {
        for (Map.Entry<Map<ItemStack, ItemStack>, ItemStack[]> entry : this.coolingList.entrySet()) {
            for (Map.Entry<ItemStack, ItemStack> entryInput : entry.getKey().entrySet()) {
                if (!this.compareItemStacks(stack, entryInput.getKey())) continue;
                return entryInput.getValue();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCoolingResult(ItemStack stack, ItemStack stackSecondary) {
        for (Map.Entry<Map<ItemStack, ItemStack>, ItemStack[]> entry : this.coolingList.entrySet()) {
            for (Map.Entry<ItemStack, ItemStack> entryInput : entry.getKey().entrySet()) {
                if (!this.compareItemStacks(stack, entryInput.getKey()) || !this.compareItemStacks(stackSecondary, entryInput.getValue())) continue;
                return entry.getValue()[this.rand.nextInt(entry.getValue().length)];
            }
        }
        return ItemStack.field_190927_a;
    }

    public Map<Map<ItemStack, ItemStack>, ItemStack[]> getCoolingList() {
        return this.coolingList;
    }

    private boolean compareItemStacks(ItemStack stack, ItemStack toCompare) {
        return toCompare.func_77973_b() == stack.func_77973_b() && (toCompare.func_77960_j() == Short.MAX_VALUE || toCompare.func_77960_j() == stack.func_77960_j());
    }
}

