/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.player_conditions.types;

import com.gildedgames.aether.api.player.IPlayerConditionModule;
import com.gildedgames.aether.api.player.conditions.types.IPlayerConditionEntity;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConditionModule;
import com.gildedgames.aether.common.player_conditions.PlayerConditionBase;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class PlayerConditionFeedEntity
extends PlayerConditionBase
implements IPlayerConditionEntity {
    private final ResourceLocation entityId;
    private final EntityEntry entityEntry;
    private final ResourceLocation uniqueId;

    public PlayerConditionFeedEntity(ResourceLocation entityId) {
        Validate.notNull((Object)entityId, (String)"entityId cannot be null.", (Object[])new Object[0]);
        this.entityId = entityId;
        this.entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.entityId);
        if (this.entityEntry == null) {
            throw new RuntimeException("Entity entry cannot be found with given entityId: " + this.entityId);
        }
        this.uniqueId = AetherCore.getResource("feedEntity:" + this.entityId);
    }

    @Override
    public ResourceLocation getUniqueIdentifier() {
        return this.uniqueId;
    }

    @Override
    public void onTracked() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onUntracked() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerConditionFeedEntity that = (PlayerConditionFeedEntity)o;
        return Objects.equals(this.entityId, that.entityId);
    }

    public int hashCode() {
        return Objects.hash(this.entityId);
    }

    @Override
    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    @Override
    public EntityEntry getEntityEntry() {
        return this.entityEntry;
    }

    @SubscribeEvent
    public void onFeedEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (!EntityUtil.checkEntityClass(entity, this.entityEntry.getEntityClass())) {
            return;
        }
        if (entity instanceof MultiPartEntityPart) {
            MultiPartEntityPart multi = (MultiPartEntityPart)entity;
            entity = (Entity)multi.field_70259_a;
        }
        if (!(entity instanceof EntityAnimal)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        IPlayerConditionModule module = playerAether.getModule(PlayerConditionModule.class);
        if (module.isConditionFlagged(this.getUniqueIdentifier())) {
            return;
        }
        EntityAnimal animal = (EntityAnimal)entity;
        if (animal.func_70877_b(player.func_184586_b(event.getHand()))) {
            int growingAge = animal.func_70874_b();
            boolean inLove = animal.func_70880_s();
            if (animal.func_70631_g_() || growingAge == 0 && !inLove) {
                this.triggerCondition(player);
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<PlayerConditionFeedEntity> {
        public PlayerConditionFeedEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new PlayerConditionFeedEntity(new ResourceLocation(json.getAsJsonObject().get("entityId").getAsString()));
        }
    }
}

