/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.player_conditions;

import com.gildedgames.aether.api.player.IPlayerConditionModule;
import com.gildedgames.aether.api.player.conditions.IPlayerCondition;
import com.gildedgames.aether.api.player.conditions.IPlayerConditionTracker;
import com.gildedgames.aether.api.player.conditions.types.IPlayerConditionListener;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConditionModule;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerConditionTracker
implements IPlayerConditionTracker,
IPlayerConditionListener {
    private final HashSet<IPlayerCondition> conditions = Sets.newHashSet();

    @Override
    public void trackConditions(Collection<IPlayerCondition> conditions) {
        for (IPlayerCondition condition : conditions) {
            if (this.conditions.contains(condition)) continue;
            condition.listen(this);
            this.conditions.add(condition);
            condition.onTracked();
        }
    }

    @Override
    public void unload() {
        for (IPlayerCondition condition : this.conditions) {
            condition.unlisten(this);
            condition.onUntracked();
        }
        this.conditions.clear();
    }

    @Override
    public void onTriggered(IPlayerCondition condition, EntityPlayer player) {
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        IPlayerConditionModule module = playerAether.getModule(PlayerConditionModule.class);
        module.flagCondition(condition.getUniqueIdentifier());
    }
}

