/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.player_conditions;

import com.gildedgames.aether.api.player.conditions.IPlayerCondition;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionFeedEntity;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionKillEntity;
import com.gildedgames.aether.common.player_conditions.types.PlayerConditionSeeEntity;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;

public class PlayerConditionDeserializer
implements JsonDeserializer<IPlayerCondition> {
    private final HashMap<ResourceLocation, Class<? extends IPlayerCondition>> conditions = new HashMap();

    public PlayerConditionDeserializer() {
        this.conditions.put(AetherCore.getResource("seeEntity"), PlayerConditionSeeEntity.class);
        this.conditions.put(AetherCore.getResource("feedEntity"), PlayerConditionFeedEntity.class);
        this.conditions.put(AetherCore.getResource("killEntity"), PlayerConditionKillEntity.class);
    }

    public IPlayerCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        if (!root.has("type")) {
            throw new JsonParseException("Missing required field 'type' for condition");
        }
        ResourceLocation type = new ResourceLocation(root.get("type").getAsString());
        if (!this.conditions.containsKey(type)) {
            throw new JsonParseException("Invalid condition type " + type);
        }
        return (IPlayerCondition)context.deserialize(json, (Type)this.conditions.get(type));
    }
}

