/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.trade;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCurrencyModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTradeModule;
import com.gildedgames.aether.common.containers.ContainerTrade;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketTradeState
implements IMessage {
    private byte state;

    public PacketTradeState() {
    }

    public PacketTradeState(byte state) {
        this.state = state;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.state);
    }

    public void fromBytes(ByteBuf buf) {
        this.state = buf.readByte();
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketTradeState, IMessage> {
        @Override
        public IMessage onMessage(PacketTradeState message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            PlayerTradeModule tradeModule = aePlayer.getModule(PlayerTradeModule.class);
            PlayerTradeModule targetTrade = tradeModule.getTarget().getModule(PlayerTradeModule.class);
            if (tradeModule.isTrading()) {
                String statusMessage = "";
                if (message.state == 0) {
                    tradeModule.setLockedIn(true);
                    targetTrade.sendState(0);
                    statusMessage = "targetlock";
                } else if (message.state == 1) {
                    tradeModule.setLockedIn(false);
                    if (targetTrade.isLockedIn()) {
                        targetTrade.setLockedIn(false);
                        tradeModule.sendState(0);
                        statusMessage = "unlockwarn";
                    } else {
                        statusMessage = "unlocksafe";
                    }
                    targetTrade.sendState(0);
                } else if (message.state == 2 && tradeModule.isLockedIn() && targetTrade.isLockedIn()) {
                    if (targetTrade.isConfirmed()) {
                        if (tradeModule.getEntity().field_71070_bA instanceof ContainerTrade && targetTrade.getEntity().field_71070_bA instanceof ContainerTrade) {
                            ContainerTrade hostContainer = (ContainerTrade)tradeModule.getEntity().field_71070_bA;
                            ContainerTrade otherContainer = (ContainerTrade)targetTrade.getEntity().field_71070_bA;
                            aePlayer.getModule(PlayerCurrencyModule.class).add((long)(targetTrade.getCoinAmount() - tradeModule.getCoinAmount()));
                            tradeModule.getTarget().getModule(PlayerCurrencyModule.class).add((long)(tradeModule.getCoinAmount() - targetTrade.getCoinAmount()));
                            for (int i = 0; i < 16; ++i) {
                                Slot slotA = hostContainer.func_75139_a(36 + i);
                                Slot slotB = otherContainer.func_75139_a(36 + i);
                                if (!slotB.func_75211_c().func_190926_b()) {
                                    tradeModule.getEntity().func_191521_c(slotB.func_75211_c().func_77946_l());
                                    slotB.func_75215_d(ItemStack.field_190927_a);
                                }
                                if (slotA.func_75211_c().func_190926_b()) continue;
                                targetTrade.getEntity().func_191521_c(slotA.func_75211_c().func_77946_l());
                                slotA.func_75215_d(ItemStack.field_190927_a);
                            }
                        }
                        tradeModule.closeGui();
                        targetTrade.closeGui();
                    } else {
                        tradeModule.setConfirmed(true);
                        targetTrade.sendState(3);
                        statusMessage = "targetconfirm";
                    }
                }
                if (!statusMessage.isEmpty()) {
                    NetworkingAether.sendPacketToPlayer(new PacketTradeMessage("aether.trade.message." + statusMessage), targetTrade.getPlayerMP());
                }
            }
            return null;
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketTradeState, IMessage> {
        @Override
        public IMessage onMessage(PacketTradeState message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            PlayerTradeModule tradeModule = aePlayer.getModule(PlayerTradeModule.class);
            if (message.state == -1) {
                tradeModule.clear();
            }
            tradeModule.updateClientState(message.state);
            return null;
        }
    }
}

