/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.trade;

import com.gildedgames.aether.client.gui.dialog.GuiTrade;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTradeModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import com.gildedgames.aether.common.network.NetworkingAether;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketTradeMessage
implements IMessage {
    private String text;
    private int entityId;

    public PacketTradeMessage() {
    }

    public PacketTradeMessage(String message, EntityPlayer player) {
        this.text = message;
        this.entityId = player.func_145782_y();
    }

    public PacketTradeMessage(String message) {
        this.text = message;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketTradeMessage, IMessage> {
        @Override
        public IMessage onMessage(PacketTradeMessage message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            PlayerTradeModule tradeModule = aePlayer.getModule(PlayerTradeModule.class);
            if (tradeModule.isTrading() && message.text.length() <= 256) {
                NetworkingAether.sendPacketToPlayer(new PacketTradeMessage(message.text, player), tradeModule.getTargetMP());
            }
            return null;
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketTradeMessage, IMessage> {
        @Override
        public IMessage onMessage(PacketTradeMessage message, EntityPlayer player) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof GuiTrade) {
                GuiTrade tradeGui = (GuiTrade)mc.field_71462_r;
                Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                if (message.entityId != 0 && entity instanceof EntityPlayer) {
                    tradeGui.sendTradeMessage((EntityPlayer)entity, (ITextComponent)new TextComponentString(message.text));
                } else {
                    TextComponentTranslation comp = new TextComponentTranslation(message.text, new Object[]{tradeGui.getTrader()});
                    comp.func_150255_a(new Style().func_150238_a(message.text.endsWith("warn") ? TextFormatting.RED : (message.text.endsWith("safe") ? TextFormatting.YELLOW : TextFormatting.AQUA)));
                    tradeGui.sendMessage((ITextComponent)comp);
                }
            }
            return null;
        }
    }
}

