/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.trade;

import com.gildedgames.aether.client.gui.dialog.GuiTrade;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PacketTradeInventory
implements IMessage {
    private final List<Pair<Integer, ItemStack>> changes = new ArrayList<Pair<Integer, ItemStack>>();
    private int decSlots;

    public PacketTradeInventory() {
    }

    public PacketTradeInventory(IInventory inventory) {
        ItemStack stack;
        for (int i = 0; i < inventory.func_70302_i_() && !(stack = inventory.func_70301_a(i)).func_190926_b(); ++i) {
            this.changes.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)stack));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.decSlots = buf.readInt();
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            byte slot = buf.readByte();
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.changes.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.decSlots);
        buf.writeByte(this.changes.size());
        for (Pair<Integer, ItemStack> pair : this.changes) {
            buf.writeByte(((Integer)pair.getKey()).intValue());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)pair.getValue()));
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketTradeInventory, IMessage> {
        @Override
        public IMessage onMessage(PacketTradeInventory message, EntityPlayer player) {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiTrade) {
                GuiTrade trade = (GuiTrade)screen;
                trade.setTradeOffer(message.changes);
            }
            return null;
        }
    }
}

