/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.effects;

import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketStatusEffect
implements IMessage {
    private ArrayList<StatusEffectData> statusEffectData;
    private int entityID;
    private int numberOfDirtyEffects;

    public PacketStatusEffect() {
    }

    public PacketStatusEffect(Entity entity) {
        this.entityID = entity.func_145782_y();
        HashMap<String, IAetherStatusEffects> map = ((IAetherStatusEffectPool)entity.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null)).getPool();
        this.statusEffectData = new ArrayList();
        for (IAetherStatusEffects effect : map.values()) {
            if (!effect.isDirty()) continue;
            this.statusEffectData.add(new StatusEffectData(effect.getEffectType().numericValue, effect.getBuildup(), effect.getIsEffectApplied(), effect.calculateResistances()));
            ++this.numberOfDirtyEffects;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.numberOfDirtyEffects = buf.readByte();
        this.entityID = buf.readInt();
        if (this.statusEffectData == null) {
            this.statusEffectData = new ArrayList();
        }
        for (int i = 0; i < this.numberOfDirtyEffects; ++i) {
            byte effectId = buf.readByte();
            byte effectBuildup = buf.readByte();
            boolean isEffectApplied = buf.readBoolean();
            double resistance = SmallDoubleByteConverter.convertByteToDouble(buf.readByte());
            this.statusEffectData.add(new StatusEffectData(effectId, effectBuildup, isEffectApplied, resistance));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.numberOfDirtyEffects);
        buf.writeInt(this.entityID);
        for (StatusEffectData data : this.statusEffectData) {
            buf.writeByte(data.effectId);
            buf.writeByte(data.buildup);
            buf.writeBoolean(data.isApplied);
            buf.writeByte((int)SmallDoubleByteConverter.convertDoubleToByte(data.resistance));
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketStatusEffect, IMessage> {
        @Override
        public IMessage onMessage(PacketStatusEffect message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            Entity entity = player.field_70170_p.func_73045_a(message.entityID);
            if (!(entity instanceof EntityLivingBase)) {
                AetherCore.LOGGER.warn("Tried to set effects for non-living entity with ID " + message.entityID);
                return null;
            }
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            IAetherStatusEffectPool map = (IAetherStatusEffectPool)entityLiving.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
            if (map != null && message.statusEffectData != null) {
                for (StatusEffectData data : message.statusEffectData) {
                    IAetherStatusEffects effect = map.createEffect(IAetherStatusEffects.effectTypes.getEffectFromNumericValue((int)((StatusEffectData)data).effectId).name, entityLiving);
                    effect.setBuildup(data.buildup);
                    effect.setApplied(data.isApplied);
                    effect.addResistance(data.resistance - 1.0);
                }
            }
            return null;
        }
    }

    public static class SmallDoubleByteConverter {
        public static byte convertDoubleToByte(double d) {
            int decimal;
            int base = MathHelper.func_76128_c((double)d);
            int returnByte = decimal = (int)((d - (double)base) * 10.0);
            returnByte <<= 4;
            return (byte)(returnByte |= base);
        }

        public static double convertByteToDouble(byte b) {
            int base = b;
            int decimal = b;
            decimal >>= 4;
            double retVal = (double)(decimal &= 0xF) * 0.1;
            return retVal += (double)(base &= 0xF);
        }
    }

    private class StatusEffectData {
        private final int effectId;
        private final int buildup;
        private final boolean isApplied;
        private final double resistance;

        StatusEffectData(int effectTypeId, int buildup, boolean isApplied, double resistance) {
            this.effectId = effectTypeId;
            this.buildup = buildup;
            this.isApplied = isApplied;
            this.resistance = resistance;
        }
    }
}

