/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.dialog;

import com.gildedgames.aether.api.dialog.IDialogController;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketOpenDialog
implements IMessage {
    private ResourceLocation name;
    private String startingNodeId;
    private Map<String, Boolean> conditionsMet;
    private NBTFunnel funnel;

    public PacketOpenDialog() {
    }

    public PacketOpenDialog(ResourceLocation res, String startingNodeId, Map<String, Boolean> conditionsMet) {
        this.name = res;
        this.startingNodeId = startingNodeId;
        this.conditionsMet = conditionsMet;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.startingNodeId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.funnel = new NBTFunnel(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.startingNodeId);
        NBTTagCompound tag = new NBTTagCompound();
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setMap("c", this.conditionsMet, NBTFunnel.STRING_SETTER, NBTFunnel.BOOLEAN_SETTER);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketOpenDialog, PacketOpenDialog> {
        @Override
        public PacketOpenDialog onMessage(PacketOpenDialog message, EntityPlayer player) {
            Map conditionsMet = message.funnel.getMap("c", NBTFunnel.STRING_GETTER, NBTFunnel.BOOLEAN_GETTER);
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            IDialogController controller = aePlayer.getModule(PlayerDialogModule.class);
            controller.setConditionsMetData(conditionsMet);
            controller.openScene(message.name, message.startingNodeId);
            return null;
        }
    }
}

