/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.dialog;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketConditionsMetData
implements IMessage {
    private Map<String, Boolean> conditionsMet;
    private NBTFunnel funnel;

    public PacketConditionsMetData() {
    }

    public PacketConditionsMetData(Map<String, Boolean> conditionsMet) {
        this.conditionsMet = conditionsMet;
    }

    public void fromBytes(ByteBuf buf) {
        this.funnel = new NBTFunnel(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setMap("c", this.conditionsMet, NBTFunnel.STRING_SETTER, NBTFunnel.BOOLEAN_SETTER);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketConditionsMetData, PacketConditionsMetData> {
        @Override
        public PacketConditionsMetData onMessage(PacketConditionsMetData message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            Map conditionsMet = message.funnel.getMap("c", NBTFunnel.STRING_GETTER, NBTFunnel.BOOLEAN_GETTER);
            if (conditionsMet != null) {
                aePlayer.getModule(PlayerDialogModule.class).setConditionsMetData(conditionsMet);
            }
            return null;
        }
    }
}

