/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets.dialog;

import com.gildedgames.aether.api.dialog.IDialogAction;
import com.gildedgames.aether.api.dialog.IDialogButton;
import com.gildedgames.aether.api.dialog.IDialogController;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketActivateButton
implements IMessage {
    private String label;

    public PacketActivateButton() {
    }

    public PacketActivateButton(String label) {
        this.label = label;
    }

    public void fromBytes(ByteBuf buf) {
        this.label = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.label);
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketActivateButton, PacketActivateButton> {
        @Override
        public PacketActivateButton onMessage(PacketActivateButton message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            IDialogController dialogController = aePlayer.getModule(PlayerDialogModule.class);
            if (dialogController.getCurrentSceneInstance() == null) {
                return null;
            }
            IDialogButton found = null;
            for (IDialogButton b : dialogController.getCurrentNode().getButtons()) {
                if (!Objects.equal((Object)message.label, (Object)b.getLabel())) continue;
                found = b;
                break;
            }
            if (found != null) {
                dialogController.activateButton(found);
            }
            return null;
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketActivateButton, PacketActivateButton> {
        @Override
        public PacketActivateButton onMessage(PacketActivateButton message, EntityPlayer player) {
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            IDialogController dialogController = aePlayer.getModule(PlayerDialogModule.class);
            if (dialogController.getCurrentSceneInstance() == null) {
                return null;
            }
            IDialogButton found = null;
            for (IDialogButton b : dialogController.getCurrentNode().getButtons()) {
                if (!Objects.equal((Object)message.label, (Object)b.getLabel())) continue;
                found = b;
                break;
            }
            if (found != null && dialogController.conditionsMet(found)) {
                Collection<IDialogAction> actions = found.getActions();
                for (IDialogAction action : actions) {
                    action.performAction(dialogController);
                }
            }
            return null;
        }
    }
}

