/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopInstanceGroup;
import com.gildedgames.aether.api.shop.ShopUtil;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.containers.ContainerShop;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import com.gildedgames.aether.common.util.helpers.ItemHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketShopSell
implements IMessage {
    private int shopIndex;

    public PacketShopSell() {
    }

    public PacketShopSell(int shopIndex) {
        this.shopIndex = shopIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.shopIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.shopIndex);
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketShopSell, IMessage> {
        @Override
        public IMessage onMessage(PacketShopSell message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            PlayerDialogModule dialogModule = playerAether.getModule(PlayerDialogModule.class);
            if (player.field_71070_bA instanceof ContainerShop && dialogModule.getTalkingCharacter() != null) {
                IShopInstanceGroup group = dialogModule.getTalkingCharacter().getShopInstanceGroup();
                if (group == null) {
                    return null;
                }
                IShopInstance shopInstance = group.getShopInstance(message.shopIndex);
                if (shopInstance != null) {
                    double value;
                    ContainerShop container = (ContainerShop)player.field_71070_bA;
                    ItemStack stackToSell = container.func_75139_a(0).func_75211_c();
                    int hash = ItemHelper.getKeyForItemStack(stackToSell);
                    IShopBuy shopBuy = null;
                    for (IShopBuy buy : container.getShopInstance().getStock()) {
                        int buyHash = ItemHelper.getKeyForItemStack(buy.getItemStack());
                        if (buyHash != hash) continue;
                        shopBuy = buy;
                        break;
                    }
                    if ((value = shopBuy != null ? ShopUtil.getFilteredPrice(shopInstance, stackToSell, shopBuy.getSellingPrice()) * (double)stackToSell.func_190916_E() : ShopUtil.getFilteredPrice(shopInstance, stackToSell, AetherAPI.content().currency().getValue(stackToSell, shopInstance.getCurrencyType().getClass()))) > 0.0) {
                        double singleValue = ShopUtil.getFilteredPrice(shopInstance, stackToSell, AetherAPI.content().currency().getSingleValue(stackToSell, shopInstance.getCurrencyType().getClass()));
                        if (shopBuy != null) {
                            singleValue = ShopUtil.getFilteredPrice(shopInstance, stackToSell, shopBuy.getSellingPrice());
                        }
                        if (singleValue < 1.0) {
                            double wholeValue = ShopUtil.getFilteredPrice(shopInstance, stackToSell, AetherAPI.content().currency().getValue(stackToSell, shopInstance.getCurrencyType().getClass()));
                            if (shopBuy != null) {
                                wholeValue = ShopUtil.getFilteredPrice(shopInstance, stackToSell, shopBuy.getSellingPrice()) * (double)stackToSell.func_190916_E();
                            }
                            double floored = MathHelper.func_76128_c((double)wholeValue);
                            double decimals = wholeValue - floored;
                            double howManyTimesDivInto = decimals / singleValue;
                            int leftover = MathHelper.func_76128_c((double)howManyTimesDivInto);
                            stackToSell.func_190920_e(leftover);
                            shopInstance.getCurrencyType().addValue((long)floored, playerAether);
                        } else {
                            container.func_75139_a(0).func_75215_d(ItemStack.field_190927_a);
                            shopInstance.getCurrencyType().addValue((long)value, playerAether);
                        }
                    }
                }
            }
            return null;
        }
    }
}

