/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.api.entity.EntityCharacter;
import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopInstanceGroup;
import com.gildedgames.aether.api.shop.ShopUtil;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.containers.ContainerShop;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import com.gildedgames.aether.common.util.helpers.ItemHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketShopBuy
implements IMessage {
    private int stockIndex;
    private int buyCount;
    private int shopIndex;

    public PacketShopBuy() {
    }

    public PacketShopBuy(int stockIndex, int buyCount, int shopIndex) {
        this.stockIndex = stockIndex;
        this.buyCount = buyCount;
        this.shopIndex = shopIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.stockIndex = buf.readInt();
        this.buyCount = buf.readInt();
        this.shopIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stockIndex);
        buf.writeInt(this.buyCount);
        buf.writeInt(this.shopIndex);
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketShopBuy, IMessage> {
        @Override
        public IMessage onMessage(PacketShopBuy message, EntityPlayer player) {
            PlayerAether playerAether;
            PlayerDialogModule dialogModule;
            EntityCharacter talking;
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            if (player.field_71070_bA instanceof ContainerShop && (talking = (dialogModule = (playerAether = PlayerAether.getPlayer(player)).getModule(PlayerDialogModule.class)).getTalkingCharacter()) != null) {
                IShopInstanceGroup group = talking.getShopInstanceGroup();
                if (group == null) {
                    return null;
                }
                IShopInstance shopInstance = group.getShopInstance(message.shopIndex);
                if (shopInstance != null && shopInstance.getStock() != null) {
                    boolean isHandFree = player.field_71071_by.func_70445_o().func_190926_b();
                    if (message.stockIndex >= 0 && message.stockIndex < shopInstance.getStock().size()) {
                        boolean isAtStackLimit;
                        IShopBuy buy = shopInstance.getStock().get(message.stockIndex);
                        if (buy.getStock() <= 0) {
                            return null;
                        }
                        int maxAllowedWithHeldStack = buy.getItemStack().func_77976_d() - player.field_71071_by.func_70445_o().func_190916_E();
                        int amount = Math.min(maxAllowedWithHeldStack, Math.min(message.buyCount, buy.getStock()));
                        if (amount <= 0) {
                            return null;
                        }
                        boolean canAfford = shopInstance.getCurrencyType().getValue(playerAether) >= (long)(ShopUtil.getFilteredPrice(shopInstance, buy) * amount);
                        boolean isBuyItem = ItemHelper.getKeyForItemStack(player.field_71071_by.func_70445_o()) == ItemHelper.getKeyForItemStack(buy.getItemStack());
                        boolean canStack = player.field_71071_by.func_70445_o().func_77985_e();
                        boolean bl = isAtStackLimit = player.field_71071_by.func_70445_o().func_190916_E() >= player.field_71071_by.func_70445_o().func_77976_d();
                        if (!isAtStackLimit && canStack && canAfford && (isHandFree || isBuyItem) && buy.getStock() > 0) {
                            if (isHandFree) {
                                buy.addStock(-amount);
                                ItemStack stack = buy.getItemStack().func_77946_l();
                                stack.func_190920_e(amount);
                                player.field_71071_by.func_70437_b(stack);
                            } else {
                                buy.addStock(-amount);
                                player.field_71071_by.func_70445_o().func_190920_e(player.field_71071_by.func_70445_o().func_190916_E() + amount);
                            }
                            shopInstance.getCurrencyType().removeValue(ShopUtil.getFilteredPrice(shopInstance, buy) * amount, playerAether);
                        }
                    }
                }
            }
            return null;
        }
    }
}

