/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerProgressModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketProgressBooleanData
implements IMessage {
    private String key;
    private boolean flag = true;

    public PacketProgressBooleanData() {
    }

    public PacketProgressBooleanData(String key, boolean flag) {
        this.key = key;
        this.flag = flag;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.flag = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        buf.writeBoolean(this.flag);
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketProgressBooleanData, IMessage> {
        @Override
        public IMessage onMessage(PacketProgressBooleanData message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            aePlayer.getModule(PlayerProgressModule.class).setBoolean(message.key, message.flag);
            return null;
        }
    }
}

