/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.init.ParticlesAether;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketParticles
implements IMessage {
    private static final ParticlesAether[] PARTICLES = ParticlesAether.values();
    private ParticlesAether particle;
    private double x;
    private double y;
    private double z;
    private double offsetX;
    private double offsetY;
    private double offsetZ;

    public PacketParticles() {
    }

    public PacketParticles(ParticlesAether particle, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        this.particle = particle;
        this.x = x;
        this.y = y;
        this.z = z;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = PARTICLES[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.offsetX = buf.readDouble();
        this.offsetY = buf.readDouble();
        this.offsetZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particle.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.offsetX);
        buf.writeDouble(this.offsetY);
        buf.writeDouble(this.offsetZ);
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketParticles, PacketParticles> {
        @Override
        public PacketParticles onMessage(PacketParticles message, EntityPlayer player) {
            switch (message.particle) {
                case SLASH: {
                    AetherCore.PROXY.spawnSlashParticleFrom(player.field_70170_p, message.x, message.y, message.z, message.offsetX, message.offsetY, message.offsetZ);
                    break;
                }
                case IMPACT: {
                    AetherCore.PROXY.spawnImpactParticleFrom(player.field_70170_p, message.x, message.y, message.z, message.offsetX, message.offsetY, message.offsetZ);
                    break;
                }
                case PIERCE: {
                    AetherCore.PROXY.spawnPierceParticleFrom(player.field_70170_p, message.x, message.y, message.z, message.offsetX, message.offsetY, message.offsetZ);
                }
            }
            return null;
        }
    }
}

