/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.registry.tab.ITab;
import com.gildedgames.aether.api.registry.tab.ITabGroup;
import com.gildedgames.aether.api.registry.tab.ITabGroupHandler;
import com.gildedgames.aether.common.network.MessageHandlerServer;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketOpenTab
implements IMessage {
    private int tabGroupIndex;
    private int tabIndex;

    public PacketOpenTab() {
    }

    public PacketOpenTab(ITab tab) {
        for (Map.Entry<Integer, ITabGroupHandler> entry : AetherAPI.content().tabs().getRegisteredTabGroups().entrySet()) {
            int groupIndex = entry.getKey();
            ITabGroupHandler handler = entry.getValue();
            for (ITab iTab : handler.getClientGroup().getTabs()) {
                if (tab != iTab) continue;
                this.tabGroupIndex = groupIndex;
                this.tabIndex = handler.getDiscriminant(tab);
                return;
            }
        }
    }

    public PacketOpenTab(int tabGroupIndex, int tabIndex) {
        this.tabGroupIndex = tabGroupIndex;
        this.tabIndex = tabIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.tabGroupIndex = buf.readInt();
        this.tabIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tabGroupIndex);
        buf.writeInt(this.tabIndex);
    }

    public static class HandlerServer
    extends MessageHandlerServer<PacketOpenTab, PacketOpenTab> {
        @Override
        public PacketOpenTab onMessage(PacketOpenTab message, EntityPlayer player) {
            if (player instanceof EntityPlayerMP && message.tabGroupIndex < AetherAPI.content().tabs().getRegisteredTabGroups().size()) {
                ITabGroupHandler tabGroupHandler = AetherAPI.content().tabs().getRegisteredTabGroups().get(message.tabGroupIndex);
                if (tabGroupHandler == null) {
                    return null;
                }
                ITabGroup<ITab> tabGroup = tabGroupHandler.getServerGroup();
                if (message.tabIndex < tabGroup.getTabs().size()) {
                    ITab tab = tabGroup.getTabs().get(message.tabIndex);
                    tab.onOpen(player);
                }
            }
            return null;
        }
    }
}

