/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.api.player.inventory.IInventoryEquipment;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerEquipmentModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PacketEquipment
implements IMessage {
    private final List<Pair<Integer, ItemStack>> changes = new ArrayList<Pair<Integer, ItemStack>>();
    private int entityId;

    public PacketEquipment() {
    }

    public PacketEquipment(PlayerAether aePlayer) {
        this.entityId = aePlayer.getEntity().func_145782_y();
        IInventoryEquipment inventory = aePlayer.getModule(PlayerEquipmentModule.class).getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            this.changes.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)inventory.func_70301_a(i)));
        }
    }

    public PacketEquipment(Entity entity, List<Pair<Integer, ItemStack>> changes) {
        this.entityId = entity.func_145782_y();
        this.changes.addAll(changes);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            byte slot = buf.readByte();
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.changes.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.changes.size());
        for (Pair<Integer, ItemStack> pair : this.changes) {
            buf.writeByte(((Integer)pair.getKey()).intValue());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)pair.getValue()));
        }
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketEquipment, IMessage> {
        @Override
        public IMessage onMessage(PacketEquipment message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            Entity entity = player.field_70170_p.func_73045_a(message.entityId);
            if (entity != null && PlayerAether.hasCapability(entity)) {
                PlayerAether aePlayer = PlayerAether.getPlayer(player);
                IInventoryEquipment inventory = aePlayer.getModule(PlayerEquipmentModule.class).getInventory();
                for (Pair pair : message.changes) {
                    inventory.func_70299_a((Integer)pair.getKey(), (ItemStack)pair.getValue());
                }
            }
            return null;
        }
    }
}

