/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.entities.monsters.EntitySwet;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketDetachSwet
implements IMessage {
    private EntitySwet.Type type;
    private int id;

    public PacketDetachSwet() {
    }

    public PacketDetachSwet(EntitySwet.Type type, int id) {
        this.type = type;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = EntitySwet.Type.fromOrdinal(buf.readInt());
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.id);
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketDetachSwet, IMessage> {
        @Override
        public IMessage onMessage(PacketDetachSwet message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            Entity entity = player.field_70170_p.func_73045_a(message.id);
            if (!(entity instanceof EntityPlayer)) {
                throw new IllegalArgumentException("Entity is not a player");
            }
            PlayerAether playerAether = PlayerAether.getPlayer((EntityPlayer)entity);
            EntitySwet remove = null;
            for (EntitySwet swet : playerAether.getModule(PlayerSwetTrackerModule.class).getLatchedSwets()) {
                if (swet.getType() != message.type) continue;
                remove = swet;
            }
            if (remove != null) {
                playerAether.getModule(PlayerSwetTrackerModule.class).detachSwet(remove);
            }
            return null;
        }
    }
}

