/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.packets;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCampfiresModule;
import com.gildedgames.aether.common.network.MessageHandlerClient;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketCampfires
implements IMessage {
    private Set<BlockPosDimension> campfires;
    private NBTFunnel funnel;

    public PacketCampfires() {
    }

    public PacketCampfires(Set<BlockPosDimension> campfires) {
        this.campfires = campfires;
    }

    public void fromBytes(ByteBuf buf) {
        this.funnel = new NBTFunnel(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        NBTFunnel funnel = new NBTFunnel(new NBTTagCompound());
        funnel.setSet("c", this.campfires);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)funnel.getTag());
    }

    public static class HandlerClient
    extends MessageHandlerClient<PacketCampfires, IMessage> {
        @Override
        public IMessage onMessage(PacketCampfires message, EntityPlayer player) {
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            Set campfires = message.funnel.getSet("c");
            PlayerAether aePlayer = PlayerAether.getPlayer(player);
            aePlayer.getModule(PlayerCampfiresModule.class).setCampfiresActivated(campfires);
            return null;
        }
    }
}

