/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network.api;

import com.gildedgames.aether.api.net.IGildedGamesAccountApi;
import com.gildedgames.aether.api.net.data.UserFeatures;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GildedGamesAccountApiImpl
implements IGildedGamesAccountApi {
    private static final String API_BASE = "https://api.gildedgames.com";
    private final ExecutorService service = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private final Gson gson = new Gson();

    @Override
    public Future<UserFeatures> retrieveUserFeatures(UUID uuid) {
        return this.service.submit(() -> {
            UserFeatures features;
            URL url = new URL("https://api.gildedgames.com/minecraft/user/" + uuid.toString() + "/features");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Expected 200 OK response");
            }
            try (InputStream stream = connection.getInputStream();
                 InputStreamReader reader = new InputStreamReader(stream);){
                features = (UserFeatures)this.gson.fromJson((Reader)reader, UserFeatures.class);
            }
            return features;
        });
    }
}

