/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.network;

import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopInstanceGroup;
import com.gildedgames.aether.client.gui.container.GuiIcestoneCooler;
import com.gildedgames.aether.client.gui.container.GuiIncubator;
import com.gildedgames.aether.client.gui.container.guidebook.GuiGuidebookInventory;
import com.gildedgames.aether.client.gui.container.guidebook.GuiGuidebookLoreTome;
import com.gildedgames.aether.client.gui.container.guidebook.GuiGuidebookStatus;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.DiscoveryTab;
import com.gildedgames.aether.client.gui.container.masonry_bench.GuiMasonryBench;
import com.gildedgames.aether.client.gui.dialog.ContainerShop;
import com.gildedgames.aether.client.gui.dialog.GuiDialogViewer;
import com.gildedgames.aether.client.gui.dialog.GuiTrade;
import com.gildedgames.aether.client.gui.misc.GuiAetherLoading;
import com.gildedgames.aether.client.gui.misc.GuiAetherTeleporterNotice;
import com.gildedgames.aether.client.gui.misc.GuiPatronRewards;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerProgressModule;
import com.gildedgames.aether.common.containers.ContainerCustomWorkbench;
import com.gildedgames.aether.common.containers.ContainerDialogController;
import com.gildedgames.aether.common.containers.ContainerLoadingScreen;
import com.gildedgames.aether.common.containers.ContainerTrade;
import com.gildedgames.aether.common.containers.guidebook.ContainerGuidebookInventory;
import com.gildedgames.aether.common.containers.guidebook.EmptyContainer;
import com.gildedgames.aether.common.containers.tiles.ContainerIcestoneCooler;
import com.gildedgames.aether.common.containers.tiles.ContainerIncubator;
import com.gildedgames.aether.common.containers.tiles.ContainerMasonryBench;
import com.gildedgames.aether.common.dialog.DialogUtil;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AetherGuiHandler
implements IGuiHandler {
    public static final int CUSTOM_WORKBENCH_ID = 1;
    public static final int INVENTORY_ID = 2;
    public static final int STATUS_ID = 3;
    public static final int LORE_TOME_ID = 4;
    public static final int DISCOVERY_ID = 5;
    public static final int FROSTPINE_COOLER_ID = 6;
    public static final int INCUBATOR_ID = 7;
    public static final int MASONRY_BENCH_ID = 8;
    public static final int AETHER_LOADING_ID = 9;
    public static final int PATRON_REWARDS_ID = 10;
    public static final int TELEPORTER_NOTICE_ID = 11;
    public static final int DIALOG_SHOP_ID = 12;
    public static final int DIALOG_VIEWER_ID = 13;
    public static final int TRADE_ID = 14;

    public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        switch (id) {
            case 1: {
                return new ContainerCustomWorkbench(player.field_71071_by, world, pos);
            }
            case 2: {
                return new ContainerGuidebookInventory(playerAether);
            }
            case 3: {
                return new EmptyContainer();
            }
            case 4: {
                return new EmptyContainer();
            }
            case 5: {
                return new EmptyContainer();
            }
            case 6: {
                return new ContainerIcestoneCooler(player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 7: {
                return new ContainerIncubator(player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 8: {
                return new ContainerMasonryBench(player, player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 9: {
                return new ContainerLoadingScreen();
            }
            case 12: {
                PlayerDialogModule dialogModule = playerAether.getModule(PlayerDialogModule.class);
                if (dialogModule.getTalkingCharacter() == null) {
                    return null;
                }
                IShopInstanceGroup group = dialogModule.getTalkingCharacter().getShopInstanceGroup();
                if (group == null) {
                    return null;
                }
                int shopIndex = pos.func_177958_n();
                IShopInstance shopInstance = group.getShopInstance(shopIndex);
                if (shopInstance == null) {
                    return null;
                }
                return new com.gildedgames.aether.common.containers.ContainerShop(player.field_71071_by, shopInstance);
            }
            case 13: {
                return new ContainerDialogController(player);
            }
            case 14: {
                return new ContainerTrade(player.field_71071_by);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        switch (id) {
            case 1: {
                return new GuiCrafting(player.field_71071_by, world, pos);
            }
            case 2: {
                return new GuiGuidebookInventory(null, playerAether);
            }
            case 3: {
                return new GuiGuidebookStatus(null, playerAether);
            }
            case 4: {
                return new GuiGuidebookLoreTome(null, playerAether);
            }
            case 5: {
                PlayerProgressModule progress = playerAether.getModule(PlayerProgressModule.class);
                DiscoveryTab.DiscoveryTabType discoveryTab = progress.getOpenedDiscoveryTabType();
                return discoveryTab.createPageContainer(playerAether);
            }
            case 6: {
                return new GuiIcestoneCooler(player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 7: {
                return new GuiIncubator(player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 8: {
                return new GuiMasonryBench(player, player.field_71071_by, (IInventory)world.func_175625_s(pos));
            }
            case 9: {
                return new GuiAetherLoading();
            }
            case 10: {
                return new GuiPatronRewards();
            }
            case 11: {
                return new GuiAetherTeleporterNotice();
            }
            case 12: {
                PlayerDialogModule dialogModule = playerAether.getModule(PlayerDialogModule.class);
                if (dialogModule.getTalkingCharacter() == null) {
                    return null;
                }
                IDialogSlide slide = DialogUtil.getSlide(dialogModule);
                IShopInstanceGroup group = dialogModule.getTalkingCharacter().getShopInstanceGroup();
                if (group == null) {
                    return null;
                }
                int shopIndex = pos.func_177958_n();
                IShopInstance shopInstance = group.getShopInstance(shopIndex);
                if (shopInstance == null || slide == null) {
                    return null;
                }
                GuiViewer prevViewer = null;
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiViewer) {
                    prevViewer = (GuiViewer)FMLClientHandler.instance().getClient().field_71462_r;
                }
                GuiDialogViewer.preventDialogControllerClose = true;
                if (slide.getRenderer().isPresent()) {
                    IDialogSlideRenderer renderer = DialogUtil.getRenderer(slide);
                    return new ContainerShop(prevViewer, player, slide, renderer, shopInstance, shopIndex);
                }
                return new ContainerShop(prevViewer, player, slide, null, shopInstance, shopIndex);
            }
            case 13: {
                PlayerDialogModule dialogModule = playerAether.getModule(PlayerDialogModule.class);
                return new GuiDialogViewer(player, dialogModule, dialogModule.getCurrentSceneInstance());
            }
            case 14: {
                GuiViewer prevViewerA = null;
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiViewer) {
                    prevViewerA = (GuiViewer)FMLClientHandler.instance().getClient().field_71462_r;
                }
                return new GuiTrade(prevViewerA, player);
            }
        }
        return null;
    }
}

